// Packet.cpp: implementation of the CPacket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Packet.h"
#include <stdlib.h>
#include <string.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPacket::CPacket()
{
	m_Type = 0;
	m_pBuffer=0;
	m_Size=m_Index=0;
}

CPacket::~CPacket()
{
	free( m_pBuffer );
}

unsigned short CPacket::GetType()
{
	return( m_Type );
}

void CPacket::SetType(unsigned short Type)
{
	m_Type = Type;
}

bool CPacket::SetSize(int Size)
{
	void * p = realloc( m_pBuffer, Size );

	if( p == NULL && Size != 0 )
		return( false );

	m_Size = Size;
	m_pBuffer = p;

	return( true );
}

bool CPacket::Pack(void *Src, int Size)
{
	if( !SetSize( m_Size + Size ) )
		return( false );

	memmove( ((char*)m_pBuffer)+m_Size-Size, 
			Src,
			Size );
	return( true );
}


