#ifndef MGOBJECT_H_SYMBOL
#define MGOBJECT_H_SYMBOL

#include <iostream>
#include <fstream>
#include <typeinfo>
using namespace std;

class MGObject
{
public:
	MGObject();
	virtual ~MGObject();

	static int GetCount() { return( m_nCount ); };

#ifdef _DEBUG
	virtual void Dump( ostream& Out ) const
	{
		Out << "Type= " << typeid( this ).name() << ", 'this'=" << this << endl;
	}
#endif
#ifndef _DEBUG
#endif

	virtual bool GetAsString( char* Dest ) const=0;
	virtual bool SetFromString( const char* Src )=0;
	virtual bool SaveToFile( ofstream& Dest ) const =0;
	virtual bool LoadFromFile( ifstream& Src ) =0;


protected:
	bool SaveToFileInt( ofstream& Dest, int Val ) const { Dest.write( (const char*)&Val, sizeof(Val) ); return( Dest.fail() ? false : true ); }
	bool LoadFromFileInt( ifstream& Src, int& Dest ) { Src.read( (char*)&Dest, sizeof(Dest) ); return( Src.fail() ? false : true ); }

	static int m_nCount;
#ifdef _DEBUG
	static MGObject* m_TheWorld;
	MGObject* m_pNext;
	friend void DumpAll( const char* Filename );
#endif

};

ostream& operator<<( ostream& Dest, const MGObject& Src );


#ifdef _DEBUG 

inline void DumpAll( const char* Filename )
{
	ofstream MyStream;
	ofstream* Dest;

	if( Filename==0 )
		Dest = (ofstream*)&cout;
	else
	{
		MyStream.open( Filename );
		if( !MyStream )
			Dest = 0;
		else
			Dest = &MyStream;

	}
	if( !Dest )
		cout << "Error with DumpAll destination" << endl;
	else
	{
		MGObject* pObject=MGObject::m_TheWorld;
		while( pObject )
		{
			pObject->Dump( *Dest );
			pObject = pObject->m_pNext;
		}

	}

}

#endif

#include "MGString.h"
#include "MGNameString.h"
#include "MGDate.h"
#include "MGException.h"
#include "MGArray.h" // Added 8/17/03
#endif

