#include <iostream>

// For Midterm:
#include "MGObject.h"

using namespace std;

#ifndef MGSTRING_H_SYMBOL
#define MGSTRING_H_SYMBOL

class MGString : public MGObject // Derived for Midterm
{
public:

	// HW2:
	MGString( const char* Src=0 );
	MGString( const MGString& Src );
	virtual ~MGString();

	bool Set( const char* Src=0 );
	bool Set( const MGString& Src ) { return( Set(Src.m_Str) ); }

	const char* GetCPointer() const;
	int GetLength() const;

	// HW3:
	const MGString& operator=( const char* Src );
	const MGString& operator=( const MGString& Src );
	int Compare( const char* Src, bool Sensitive=false ) const;
	bool operator==( const char* Src ) const { return( Compare( Src, m_Sensitive )==0 ); }
	bool operator!=( const char* Src ) const { return( Compare( Src, m_Sensitive )!=0 ); }
	bool operator>( const char* Src ) const { return( Compare( Src, m_Sensitive )>0 ); }
	bool operator>=( const char* Src ) const { return( Compare( Src, m_Sensitive )>=0 ); }
	bool operator<( const char* Src ) const { return( Compare( Src, m_Sensitive )<0 ); }
	bool operator<=( const char* Src ) const { return( Compare( Src, m_Sensitive )<=0 ); }

	bool Insert( const char* Str, int Index );
	bool Insert( const MGString& Src, int Index )
	{ return( Insert( Src.GetCPointer(), Index ) ); }

	bool Append( const char* Str ) { return( Insert( Str, GetLength() ) ); }
	bool Append( const MGString& Src ) { return( Insert( Src.GetCPointer(), GetLength() ) ); }


	MGString operator+=( const char* Str );
	MGString operator+( const char* Op2 ) const;
	MGString operator+( const MGString& Op2 ) const;

	operator const char* () const { return( GetCPointer() ); }

	// Note: It's a public member.  Any pros or cons?
	static bool m_Sensitive;

	// HW #4:
	virtual void Changed() { }

	// Midterm:
	virtual bool SaveToFile( ofstream& Dest ) const;
	virtual bool LoadFromFile( ifstream& Src );

	virtual bool GetAsString( char* Dest ) const { strcpy( Dest, GetCPointer() ); return true; }
	virtual bool SetFromString( const char* Src ) { return( Set( Src ) ); }

	// HW #5:
	char& operator[](int Index );
	
protected:
	bool SetSize( int NewSize );
	char * m_Str;
};

ostream& operator<<( ostream& Dest, const MGString& Str );

#endif
