
#include "mgobject.h"

bool MGString::m_Sensitive=false;

MGString::MGString( const char* Src )
{
	m_Str = 0;
	Set( Src );
}

MGString::MGString( const MGString& Src )
{
	m_Str=0;
	Set( Src.m_Str );
}

MGString::~MGString()
{

	if( m_Str )
		delete[] m_Str;
}

bool MGString::Set( const char* Src )
{
	char* Tmp=0;

	if( Src && *Src )
	{
		try
		{
			Tmp = new char[strlen( Src ) + 1 ];
		}
		catch( ... ) { } // Ignore allocate exception

		if( !Tmp )
			return( false );
	}

	if( m_Str )
		delete[] m_Str;
	m_Str = Tmp;
	if( m_Str )
		strcpy( m_Str, Src );
	
	// Let derived classes know data has changed
	Changed();

	return( true );
}

const char* MGString::GetCPointer() const
{
	return( m_Str ? m_Str : "" );
}

int MGString::GetLength() const
{
	if( m_Str )
		return( strlen(m_Str) );
	return( 0 );
}


const MGString& MGString::operator=( const char* Src )
{
	Set( Src );
	return( *this );
}

const MGString& MGString::operator=( const MGString& Src )
{
	Set( Src );
	return( *this );
}

int MGString::Compare( const char* Src, bool Sensitive ) const
{
	if( Sensitive )
		return( strcmp( GetCPointer(), Src ) );
	return( stricmp( GetCPointer(), Src ) );
}

bool MGString::SetSize( int NewSize )
{
	if( !NewSize )
	{
		if( m_Str )
			delete[] m_Str;
		m_Str = 0;
		return( true );
	}
	char *Tmp=0;
	
	try {
		Tmp = new char[NewSize];
	} catch(...) { }
	
	if( !Tmp )
		return( false );
	int Len = GetLength()+1;

	if( m_Str )
	{
		memmove( Tmp, m_Str, NewSize < Len? NewSize : Len );
		Tmp[NewSize-1] = '\0';
		delete[] m_Str;
	}
	else
		Tmp[0]='\0';

	m_Str = Tmp;
	return( true );
}

bool MGString::Insert( const char* Str, int Index )
{
	int ExtraSize = strlen(Str);

	if( Index > GetLength() )
		return( false );

	if( !SetSize( GetLength() + ExtraSize +1) )
		return( false );
	memmove( m_Str+Index+ExtraSize, m_Str+Index, GetLength()-Index );
	memmove( m_Str+Index, Str, ExtraSize );
	Changed();
	return( true );
}

MGString MGString::operator+( const char* Op2 ) const
{
	MGString Tmp = *this;
	Tmp.Append( Op2 );
	return( Tmp );
}

MGString MGString::operator+( const MGString& Op2 ) const
{
	MGString Tmp = *this;
	Tmp.Append( Op2.GetCPointer() );
	return( Tmp );
}

MGString MGString::operator+=( const char* Str )
{
	Append( Str );
	return( *this );
}

ostream& operator<<( ostream& Dest, const MGString& Str )
{
	Dest << Str.GetCPointer();
	return( Dest );
}

// Midterm:
bool MGString::SaveToFile( ofstream& Dest ) const
{
	int i = GetLength();
	Dest.write( (const char*)&i, sizeof( i ) );
	if( Dest.fail() )
		return( false );
	if( i )
	{
		Dest.write( m_Str, i );
		if( Dest.fail() )
			return( false );
	}
	return( true );
}

bool MGString::LoadFromFile( ifstream& Src )
{
	int i;
	Src.read( (char*)&i, sizeof( i ) );
	if( Src.fail() )
		return( false );
	if( !SetSize(i+1) )
		return( false );
	Src.read( m_Str, i );
	if( Src.fail() )
		return( false );
	m_Str[i] = '\0';
	
	Changed();
	return( true );
}

char& MGString::operator[](int Index )
{
	if( Index < 0 || !m_Str || Index > strlen(m_Str) )
		MGThrowStringException( "Bad index" );
	return( m_Str[Index] );
}