
#include "MGString.h"

class MGNameString : public MGString
{
public:
	MGNameString( const MGString& Src ) 
		: MGString( Src )
	{
		Changed();
	}

	MGNameString( const char* Src=0 ) : MGString( Src )
	{
		Changed();
	}
	
	MGNameString& operator=( const char* Src )
	{
		if( Src != m_Str )
			Set(Src);
		return( *this );
	}

	MGNameString& operator=( const MGString& Src )
	{
		if( &Src != this )
			Set( Src.GetCPointer() );
		return( *this );
	}

	void Changed()
	{
		MGString::Changed();
		int i, j = GetLength();
		for( i=0; i < j; i++ )
		{
			if( i==0 || m_Str[i-1]==' ')
				m_Str[i] = toupper( m_Str[i] );
			else
				m_Str[i] = tolower( m_Str[i] );
		}
		// Changed does not call Changed.
	}
};
