
#ifndef _MGEXCEPTION_H
#define _MGEXCEPTION_H

#include <fstream>
using namespace std;

// Base class for all the exception objects.
class MGException : public MGObject
{
public:
	MGException( const char* Message=0 )
	{
		if( Message )
			strcpy( m_Str, Message );
	}

	virtual bool GetAsString( char* Dest ) const;
	virtual bool SetFromString( const char* Src );
	virtual bool SaveToFile( ofstream& Dest ) const;
	virtual bool LoadFromFile( ifstream& Src );

protected:
	char m_Str[512];

};

class MGFileException : public MGException
{
public:
	MGFileException( const char* Operation, const char* File, const char* SrcFile, int Line )
	{
		sprintf( m_Str, "File error: %s, %s (%s:%d)", Operation, File, SrcFile, Line );
	}
};
#define MGThrowFileException(Op,F) throw MGFileException(Op, F, __FILE__, __LINE__ );

class MGMemoryException : public MGException
{
public:
	MGMemoryException( const char* Operation, int Size, const char* SrcFile, int Line  )
	{
		sprintf( m_Str, "Memory error: %s, %d bytes (%s:%d)", Operation, Size, SrcFile, Line );
	}
};
#define MGThrowMemoryException(Op,S) throw MGMemoryException(Op, S, __FILE__,__LINE__ );

// MGStringException for the String class.
class MGStringException : public MGException
{
public:
	MGStringException( const char* Operation, const char* SrcFile, int Line  )
	{
		sprintf( m_Str, "MGString error: %s (%s:%d)", Operation, SrcFile, Line );
	}
};
#define MGThrowStringException(Op) throw MGStringException(Op, __FILE__,__LINE__ );


#endif
