#include "MGObject.h"

bool MGDate::SetFromString( const char* Src )
{
	int M, D, Y;
	M = atoi( Src );
	while( *Src && *Src >='0' && *Src <='9' )
		Src++;
	if( *Src )
		Src++;
	D = atoi( Src );
	while( *Src && *Src >='0' && *Src <='9' )
		Src++;
	if( *Src )
		Src++;
	Y = atoi( Src );
	if( Y < 100 )
		Y += 1900;
	SetYear( Y );
	SetMonth( M );
	SetDay( D );
	return( true );
}

bool MGDate::GetAsString( char* Dest ) const
{
	sprintf(Dest, "%d/%d/%d", m_Month, m_Day, m_Year );
	return( true );
}

bool MGDate::SaveToFile( ofstream& Dest ) const
{
	if( !SaveToFileInt( Dest, m_Year ) )
		return( false );
	if( !SaveToFileInt( Dest, m_Month ) )
		return( false );
	if( !SaveToFileInt( Dest, m_Day ) )
		return( false );
	return( true );
}

bool MGDate::LoadFromFile( ifstream& Src )
{

	if( !LoadFromFileInt( Src, m_Year ) )
		return( false );
	if( !LoadFromFileInt( Src, m_Month ) )
		return( false );
	if( !LoadFromFileInt( Src, m_Day ) )
		return( false );
	return( true );
}

int MGDate::GetMonth()
{
	return( m_Month );
}

int MGDate::GetDay()
{
	return( m_Day );
}
int MGDate::GetYear()
{
	return( m_Year );
}

void MGDate::SetMonth( int Month )
{
	if( Month < 1 || Month > 12 )
		throw "Bad Month";
	m_Month = Month;
}

void MGDate::SetDay( int Day )
{
	if( Day < 1 || Day > 31 )
		throw "Bad Day";
	m_Day = Day;
}
void MGDate::SetYear( int Year )
{
	if( Year < 1 || Year > 3000 )
		throw "Bad Year";
	m_Year = Year;
}
