// MGApplication.cpp: implementation of the MGApplication class.
//
//////////////////////////////////////////////////////////////////////

#include "MGApplication.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MGApplication::MGApplication(const char* Datafile)
{
	if( Datafile )
		m_DataFile = Datafile;
}

MGApplication::~MGApplication()
{

}

bool MGApplication::Run()
{
	bool Ret;
	if( !OnStartup() )
		return( false );
	Ret = OnRun();
	OnShutdown();
	return( Ret );
}

int MGApplication::Menu(char *MenuItems[])
{
	int i;
	char Ret[128];
	cout << "\nMenu==================="<<endl;
	for( i=0; MenuItems[i]!=NULL; i++ )
	{
		cout << i+1 << ". " << MenuItems[i] << endl;
	}
	cout << "======================="<<endl;
	do {
		cout << "Enter choice (1-" << i << ") and ENTER:" << endl;
		GetLine( Ret, sizeof(Ret));
	} while( atoi(Ret)<1 || atoi(Ret) >i );
	return( atoi(Ret) );

}

void MGApplication::GetLine(char *Dest, int Max)
{
	cin.getline( Dest, Max );
}

int MGApplication::GetNum( char* Prompt, int Min, int Max)
{
	char Tmp[128];

	do {
		cout << Prompt << endl;
		GetLine( Tmp, sizeof(Tmp));
	} while( atoi( Tmp )<Min || atoi(Tmp)>Max);
	return( atoi(Tmp) );
}
