// AnAPDemo.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <time.h>
#include <iostream>
using namespace std;

void Foo()
{
	throw "Up";
}

void Boo();

int main(int argc, char* argv[])
{
	try {
		Boo();
	} catch( char * pE )
	{
		cout << pE << endl;
	}

	return 0;
}

template< class RT >
class AutoPointer
{
public:
	AutoPointer( int Size = 0 )
	{
		m_Offset=0;
		m_pData = 0;
		m_Size = Size;
		if( Size )
			Init( Size );
	}
	virtual ~AutoPointer()
	{
		delete []m_pData;

	}

	void Init( int Size )
	{
		delete[] m_pData;
		m_pData = 0; 
		m_Offset = 0;

		m_pData = new RT[Size];

		if( !m_pData )
			throw "Unable to init AutoPointer";
		m_Size = Size;
	}

	RT& operator[]( int Index )
	{
		Index += m_Offset;
		if( Index <0 || Index >= m_Size )
			throw "Invalid Index";
		return( m_pData[ Index ] );
	}
	RT* operator->()
	{
		return( & operator[]( 0 ) );
	}

	RT* operator++() // Pre-inc
	{
		m_Offset++;
		return( m_pData + m_Offset );
	}
	RT* operator++(int Bogus) // Post-inc
	{
		RT* Ret = m_pData + m_Offset;
		m_Offset++;
		return( Ret );
	}
	RT* operator--()  //Pre-dec
	{
		m_Offset--;
		return( m_pData + m_Offset );
	}
	RT* operator--(int Bogus)  //Post-dec
	{
		m_Offset--;
		return( m_pData + m_Offset );
	}
	

protected:
	RT * m_pData;
	int m_Size;
	int m_Offset;

};

void Boo()
{
	//char * p;
	AutoPointer<char> p;


	//char * p = new char[100];
	p.Init( 100 );

	p[0] = 'a';
	p[1] = 'b';
	// p[0] > p.operator[](0) > m_pData[0]
	p++;
	cout << p[0] << endl;

//	p[500] = 'z';

	p++;
//	p--;
//	Foo();

	AutoPointer< struct tm> T;

	T.Init( 50 );

	T->tm_mday = 99;
	cout << T->tm_mday << endl;

	// T[0].tm_mday = 0;



//	delete[] p;

}

