// PNAlarmClockCtl.cpp : Implementation of the CPNAlarmClockCtrl ActiveX Control class.

#include "stdafx.h"
#include "PNAlarmClock.h"
#include "PNAlarmClockCtl.h"
#include "PNAlarmClockPpg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CPNAlarmClockCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CPNAlarmClockCtrl, COleControl)
	//{{AFX_MSG_MAP(CPNAlarmClockCtrl)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CPNAlarmClockCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CPNAlarmClockCtrl)
	DISP_PROPERTY_EX(CPNAlarmClockCtrl, "AlarmTime", GetAlarmTime, SetAlarmTime, VT_BSTR)
	DISP_STOCKPROP_FONT()
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CPNAlarmClockCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CPNAlarmClockCtrl, COleControl)
	//{{AFX_EVENT_MAP(CPNAlarmClockCtrl)
	EVENT_CUSTOM("Alarm", FireAlarm, VTS_NONE)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CPNAlarmClockCtrl, 2)
	PROPPAGEID(CPNAlarmClockPropPage::guid)
    PROPPAGEID( CLSID_CFontPropPage )
END_PROPPAGEIDS(CPNAlarmClockCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CPNAlarmClockCtrl, "PNALARMCLOCK.PNAlarmClockCtrl.1",
	0x6f6032f0, 0x59b1, 0x11d4, 0xa0, 0x14, 0x8, 0, 0x9, 0xee, 0x62, 0xaa)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CPNAlarmClockCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DPNAlarmClock =
		{ 0x6f6032ee, 0x59b1, 0x11d4, { 0xa0, 0x14, 0x8, 0, 0x9, 0xee, 0x62, 0xaa } };
const IID BASED_CODE IID_DPNAlarmClockEvents =
		{ 0x6f6032ef, 0x59b1, 0x11d4, { 0xa0, 0x14, 0x8, 0, 0x9, 0xee, 0x62, 0xaa } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwPNAlarmClockOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CPNAlarmClockCtrl, IDS_PNALARMCLOCK, _dwPNAlarmClockOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::CPNAlarmClockCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CPNAlarmClockCtrl

BOOL CPNAlarmClockCtrl::CPNAlarmClockCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_PNALARMCLOCK,
			IDB_PNALARMCLOCK,
			afxRegApartmentThreading,
			_dwPNAlarmClockOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::CPNAlarmClockCtrl - Constructor

CPNAlarmClockCtrl::CPNAlarmClockCtrl()
{
	// For controlling SetTimer calls
	m_TimerSet = false;
	m_AlarmH=m_AlarmM=m_AlarmS=-1;
	InitializeIIDs(&IID_DPNAlarmClock, &IID_DPNAlarmClockEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::~CPNAlarmClockCtrl - Destructor

CPNAlarmClockCtrl::~CPNAlarmClockCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::OnDraw - Drawing function

void CPNAlarmClockCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{

	// Set Timer, if not already done
	if( !m_TimerSet )
	{
		m_TimerSet = true;
		SetTimer( 1, 1000, 0 );
	}

	// Clear out control area and draw border
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	pdc->DrawEdge( (RECT*)&rcBounds, EDGE_SUNKEN, BF_RECT );
	
	// Select the Stock Font property into the DC
	CFont* pOldFont = SelectStockFont(pdc);
	
	// Get the current time
	m_Now = CTime::GetCurrentTime();
	
	// Output the current time
	pdc->TextOut( 4, 4, m_Now.Format( "%I:%M:%S %p" ) );
	
	// Restore the original font
	pdc->SelectObject( pOldFont );
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::DoPropExchange - Persistence support

void CPNAlarmClockCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.
	PX_String( pPX, "AlarmTime", m_AlarmTime );

}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::OnResetState - Reset control to default state

void CPNAlarmClockCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl::AboutBox - Display an "About" box to the user

void CPNAlarmClockCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_PNALARMCLOCK);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CPNAlarmClockCtrl message handlers


BSTR CPNAlarmClockCtrl::GetAlarmTime() 
{
	CString strResult;

	strResult = m_AlarmTime;
	
	return strResult.AllocSysString();
}

void CPNAlarmClockCtrl::SetAlarmTime(LPCTSTR lpszNewValue) 
{
	// TODO: Add your property handler here
	int H=-1, M=-1, S=-1;

	if( lpszNewValue[0] == '\0' )
	{
		m_AlarmH=m_AlarmM=m_AlarmS=-1;
		m_AlarmTime = lpszNewValue;
	}
	else
	{
		H = atoi( lpszNewValue );
		while( *lpszNewValue && *lpszNewValue != ':' )
			lpszNewValue++;
		if( *lpszNewValue )
			M = atoi( ++lpszNewValue );
		while( *lpszNewValue && *lpszNewValue != ':' )
			lpszNewValue++;
		if( *lpszNewValue )
			S = atoi( ++lpszNewValue );
		if( H>=0 && H <=23 && M >=0 && M <= 59 && S >=0 && S<=59 )
		{
			m_AlarmH = H;
			m_AlarmM = M;
			m_AlarmS = S;
			m_AlarmTime = lpszNewValue;
		}
	}

	SetModifiedFlag();
}

void CPNAlarmClockCtrl::OnTimer(UINT nIDEvent) 
{
	// Force control to be redrawn, to display new time
	InvalidateControl();
	
	// Check to see if new time is the Alarm Time
	m_Now = CTime::GetCurrentTime();
	if( m_Now.GetHour() == m_AlarmH && m_Now.GetMinute()==m_AlarmM && m_Now.GetSecond()==m_AlarmS )
		FireAlarm(); // If so, fire the Alarm Event

	COleControl::OnTimer(nIDEvent);
}
