// ImageViewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ImageViewer.h"
#include "ImageViewerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageViewerDlg dialog

CImageViewerDlg::CImageViewerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImageViewerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImageViewerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_Width = m_Height = m_Left = m_Top = 0;

}

void CImageViewerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImageViewerDlg)
	DDX_Control(pDX, IDC_IMAGE, m_Image);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CImageViewerDlg, CDialog)
	//{{AFX_MSG_MAP(CImageViewerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_LOAD, OnLoad)
	ON_BN_CLICKED(IDC_COPY, OnCopy)
	ON_BN_CLICKED(IDC_PASTE, OnPaste)
	ON_BN_CLICKED(IDC_ZOOMSEL, OnZoomsel)
	ON_BN_CLICKED(IDC_ZOOMNORM, OnZoomnorm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageViewerDlg message handlers

BOOL CImageViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CImageViewerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CImageViewerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CImageViewerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CImageViewerDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CImageViewerDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CImageViewerDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	EndDialog(0);
}

void CImageViewerDlg::OnLoad() 
{

	CFileDialog X(TRUE);

	// Invoke file open dialog, to select image
	if( X.DoModal() == IDOK )
	{
		// Set the Selected filename as the Image in the OCX
		m_Image.SetImage( X.GetPathName() );

		// Create a BOOL type variant
		COleVariant vFalse( (SHORT)FALSE, VT_BOOL );

		// Tell the Image control to fit the image inside the control
		m_Image.FitTo( 0, vFalse );

		//  Tell the Image control to display the image
		m_Image.Display();
	}
}

void CImageViewerDlg::OnCopy() 
{
	// Create VARIANT-compatible parameters for ClipboardCopy function
	COleVariant Left( m_Left );
	COleVariant Top( m_Top );
	COleVariant Width( m_Width );
	COleVariant Height( m_Height );

	// Draw the selection rectangle
	m_Image.DrawSelectionRect( m_Left, m_Top, m_Width, m_Height );
	// Copy what is within the selection rectangle to the clipboard
	m_Image.ClipboardCopy( Left, Top, Width, Height );
	
}

void CImageViewerDlg::OnPaste() 
{
	if( m_Image.IsClipboardDataAvailable() )
	{
		COleVariant Zero((short)0);
		m_Image.ClipboardPaste( Zero, Zero );
	}
}

BEGIN_EVENTSINK_MAP(CImageViewerDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CImageViewerDlg)
	ON_EVENT(CImageViewerDlg, IDC_IMAGE, 4 /* SelectionRectDrawn */, OnSelectionRectDrawnImage, VTS_I4 VTS_I4 VTS_I4 VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CImageViewerDlg::OnSelectionRectDrawnImage(long Left, long Top, long Width, long Height) 
{
	// TODO: Add your control notification handler code here
	m_Left = Left;
	m_Top = Top;
	m_Width = Width;
	m_Height = Height;
}

void CImageViewerDlg::OnZoomsel() 
{
	if( m_Width )
		m_Image.ZoomToSelection();
}

void CImageViewerDlg::OnZoomnorm() 
{
	// TODO: Add your control notification handler code here
	COleVariant vTrue( (SHORT)TRUE, VT_BOOL );
	m_Image.FitTo( 0, vTrue );
}
