// SynchDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SynchDemo.h"
#include "SynchDemoDlg.h"

#include <afxmt.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSynchDemoDlg dialog

CSynchDemoDlg::CSynchDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSynchDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSynchDemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSynchDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSynchDemoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSynchDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CSynchDemoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GOEVENT, OnGoevent)
	ON_BN_CLICKED(IDC_GOMUTEX, OnGomutex)
	ON_BN_CLICKED(IDC_GOCRITICAL, OnGocritical)
	ON_BN_CLICKED(IDC_GOSEMAPHORE, OnGosemaphore)
	ON_BN_CLICKED(IDC_GONOTIFICATION, OnGonotification)
	//}}AFX_MSG_MAP
	ON_MESSAGE( WM_USER+1, OnNotification)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSynchDemoDlg message handlers

BOOL CSynchDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSynchDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSynchDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSynchDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

UINT EventDemo( LPVOID vpParam)
{
	// Create CEvent object in child thread, with same name
	CEvent Event(FALSE,FALSE, "CEventDemo");
	
	// Set the event to 'signaled' (matches WaitForSingleObject in main thread)
	Event.SetEvent();
	
	// Do nothing for 4 seconds
	Sleep(4000);

	// Notify main thread that we are done.
	Event.SetEvent();

	return( 0 );
}

void CSynchDemoDlg::OnGoevent() 
{
	// Create CEvent object in main thread
	CEvent Event(FALSE,FALSE, "CEventDemo");

	// Start the child thread
	AfxBeginThread( EventDemo, 0 );

	// Wait for the Event signal
	while( WaitForSingleObject( Event, 0 ) == WAIT_TIMEOUT )
		;

	// Reset the signal state
	Event.ResetEvent();

	int Counter=0;
	CString TmpStr;

	// While the event signal is not received a second time,
	// display some text on screen.
	while( WaitForSingleObject( Event, 0 ) == WAIT_TIMEOUT  )
	{
		Counter++;
		TmpStr.Format( "Waiting (%d)...", Counter );
		SetDlgItemText( IDC_EVENTSTATUS, TmpStr );
	}
	SetDlgItemText( IDC_EVENTSTATUS, "We got our event notification" );

}

UINT MutexDemo( LPVOID vpParam)
{
	// Get the passes parameter into a char* for working
	char* pStr = (char*)vpParam;

	// Create a Mutex object, named CMutexDemo, for the main thread
	CMutex Mutex( FALSE, "CMutexDemo" );

	// Lock the Mutex, so no one else can use it
	Mutex.Lock();
	strcpy( pStr, "Mutex" );
	
	// Lets add a delay, for demonstration purposes.  In reality, a
	// thread should attempt to unlock as quickly as possible.
	Sleep(4000);

	// When we are done working with the data, we unlock the Mutex
	Mutex.Unlock();
	return( 0 );
}

void CSynchDemoDlg::OnGomutex() 
{
	// Create a Mutex object, named CMutexDemo, for the main thread
	CMutex Mutex( FALSE, "CMutexDemo" );
	char String[128];

	// Start the child thread
	AfxBeginThread( MutexDemo, String );

	// Give child thread time to start up
	Sleep(1000);
	CString TmpStr;

	SetDlgItemText( IDC_MUTEXSTATUS, "Waiting to access data..." );
	
	// Lock the Mutex, so we can have access to the String variable.
	// This line of code will wait until the Child thread unlocks its Mutex
	// object, at which point the Lock will return.  You could optionally specify
	// a time-out period in milliseconds as a parameter to Lock.
	Mutex.Lock();
	
	TmpStr.Format( "We could access our data: %s", String );
	SetDlgItemText( IDC_MUTEXSTATUS, TmpStr );

	// Unlock the Mutex for the String variable.
	Mutex.Unlock();
}

class CriticalParam
{
public:
	CCriticalSection m_Critical;
	char m_String[128];
};

UINT CriticalDemo( LPVOID vpParam)
{
	// Get the passed parameter (critical section and string data)
	CriticalParam* pCritical = (CriticalParam*)vpParam;


	// Lock the Mutex, so no one else can use it
	pCritical->m_Critical.Lock();
	strcpy( pCritical->m_String, "CriticalSection" );
	
	// Lets add a delay, for demonstration purposes.  In reality, a
	// thread should attempt to unlock as quickly as possible.
	Sleep(4000);

	// When we are done working with the data, we unlock the Mutex
	pCritical->m_Critical.Unlock();
	return( 0 );
}

void CSynchDemoDlg::OnGocritical() 
{
	// Create a CriticalParam object, with CriticalSection and String in it
	CriticalParam Critical;

	// Start the child thread
	AfxBeginThread( CriticalDemo, &Critical );

	// Give child thread time to start up
	Sleep(1000);
	CString TmpStr;

	SetDlgItemText( IDC_CRITICALSTATUS, "Waiting to access data..." );
	
	// Lock the Critical Section, so we can have access to the String variable.
	// This line of code will wait until the Child thread unlocks the shared
	// Critical Section object, at which point the Lock will return.  
	Critical.m_Critical.Lock();
	
	TmpStr.Format( "We could access our data: %s", Critical.m_String );
	SetDlgItemText( IDC_CRITICALSTATUS, TmpStr );

	// Unlock the Critical Section for the String variable.
	Critical.m_Critical.Unlock();

}

UINT SemaphoreDemo( LPVOID vpParam)
{
	// Create semaphore object.  Since the main thread created the
	// real semaphore, we will just get a handle to the existing one.
	// Because of this, the first two parameters to the constructor
	// are ignored.
	CSemaphore Semaphore( 1, 1, "CSemaphoreDemo" );

	// Lock the Semaphore.  This decrements the allowable accesses by 1
	Semaphore.Lock();

	// Some bogus 4 second process
	Sleep( 4000 );
	
	// Unlock the semaphore.  This increments the allowable accesses by 1
	Semaphore.Unlock();

	return( 0 );
}

void CSynchDemoDlg::OnGosemaphore() 
{
	// Create a CSemaphore, with 2 allowable accessors
	CSemaphore Semaphore( 2, 2, "CSemaphoreDemo" );

	SetDlgItemText( IDC_SEMAPHORESTATUS, "Starting threads..." );
	CTime Start = CTime::GetCurrentTime();
	
	// Create 2 threads.  This is the limit of allowable threads
	// finish.
	AfxBeginThread( SemaphoreDemo, 0 );
	AfxBeginThread( SemaphoreDemo, 0 );
 
	// Give those threads a moment to start up
	Sleep( 500 );

	// Then we try to access the semaphore.  Since we would be
	// resource #3, we have to wait until one of the other two
	// threads releases the semaphore (about 4 seconds)
	Semaphore.Lock();

	CTime Stop = CTime::GetCurrentTime();

	CString TmpString;

	TmpString.Format( "Started: %s  Stopped: %s", 
		(LPCSTR)Start.Format( "%H:%M:%S"), 
		(LPCSTR)Stop.Format( "%H:%M:%S") );

	SetDlgItemText( IDC_SEMAPHORESTATUS, TmpString );

}

UINT NotificationDemo( LPVOID vpParam)
{
	// A threading function that demonstrate how to send windows messages
	// to the main thread to indicate an event.
	for( int i=0; i < 4; i++ )
	{
		Sleep( i*1000 );
		AfxGetMainWnd()->PostMessage( WM_USER+1, i+1 );
	}
	AfxGetMainWnd()->PostMessage( WM_USER+1, -1 );
	return( 0 );
}

void CSynchDemoDlg::OnNotification( WPARAM wParam, LPARAM lParam ) 
{
	// The handler function for the notification messages sent
	// by NotificationDemo.
	CString TmpString;
	if( wParam == -1 )
		TmpString = "Child thread finished";
	else
		TmpString.Format( "Child thread sent me %d", wParam );
	SetDlgItemText( IDC_NOTIFICATIONSTATUS, TmpString );
}

void CSynchDemoDlg::OnGonotification() 
{
	// Start the Notification demo thread
	AfxBeginThread( NotificationDemo, 0 );
}
