// LookFor.h: interface for the CLookFor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LOOKFOR_H__537D45F4_85A4_11D3_9EC0_080009EE62AA__INCLUDED_)
#define AFX_LOOKFOR_H__537D45F4_85A4_11D3_9EC0_080009EE62AA__INCLUDED_

#include <afxmt.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CLookFor  
{
public:
	// Initialization and interaction support
	void AddFound( CFileFind& Found );
	void SetData( const CString& Named, const CString& Path, HWND hFindButton, HWND hStartButton );
	void SetPath( const CString& Path ) { m_In = Path; }
	
	// User interface interaction
	static void Start();
	static void Stop();
	static void Cancel();
	static bool IsCanceled() { return( m_bCancel ); }
	static bool IsRunning() { return( m_bRunning ); }

	// Searching path support
	const CString& GetPath() { return( m_In ); }
	const CString& GetNamed() { return( m_Named ); }

	CLookFor();
	virtual ~CLookFor();

	// Found items (Each found item is 4 strings)
	static CStringArray m_Found;

	// Implement thread synchronization
	void Lock() { m_CriticalSection.Lock(); }
	void Unlock() { m_CriticalSection.Unlock(); }
protected:
	CString m_In;
	static CCriticalSection m_CriticalSection;
	static CString m_Named;
	static HWND m_hFindButton;
	static HWND m_hStopButton;
	static volatile bool m_bCancel;
	static volatile bool m_bRunning;

};

#endif // !defined(AFX_LOOKFOR_H__537D45F4_85A4_11D3_9EC0_080009EE62AA__INCLUDED_)
