// LookFor.cpp: implementation of the CLookFor class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MFileFind.h"
#include "LookFor.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HWND CLookFor::m_hFindButton;
HWND CLookFor::m_hStopButton;
CString CLookFor::m_Named;
volatile bool CLookFor::m_bCancel;
volatile bool CLookFor::m_bRunning;
CCriticalSection CLookFor::m_CriticalSection;
CStringArray CLookFor::m_Found;

CLookFor::CLookFor()
{
	
}

CLookFor::~CLookFor()
{

}

// Initialize object
void CLookFor::SetData( const CString& Named, const CString& Path, HWND hFindButton, HWND hStopButton )
{
	m_Named = Named;
	m_In = Path;
	m_hFindButton = hFindButton;
	m_hStopButton = hStopButton;
}

// Set Start status for the object
void CLookFor::Start() 
{ 
	m_bRunning = true;
	m_bCancel = false; 
	if( m_hFindButton )
		::EnableWindow( m_hFindButton, FALSE );
	if( m_hStopButton )
		::EnableWindow( m_hStopButton, TRUE );
}

// Set Stopped status for object
void CLookFor::Stop()
{
	m_bRunning = false;
	m_bCancel = false; 
	if( m_hFindButton )
		::EnableWindow( m_hFindButton, TRUE );
	if( m_hStopButton )
		::EnableWindow( m_hStopButton, FALSE );

}

// Set Canceled status for object
void CLookFor::Cancel() 
{ 
	m_bCancel = true; 
	
	while( 	m_bRunning == true )
		;
	if( m_hFindButton )
		::EnableWindow( m_hFindButton, TRUE );
	if( m_hStopButton )
		::EnableWindow( m_hStopButton, FALSE );
}
	

// Add information for a found item to collection class
void CLookFor::AddFound(CFileFind &Found)
{
	m_CriticalSection.Lock();

	CString Str;
	CTime Time;

	m_Found.Add( Found.GetFileName() );
	m_Found.Add( GetPath() );
	if( Found.IsDirectory() )
		Str = "<DIR>";
	else
		Str.Format( "%d", Found.GetLength() );
	m_Found.Add( Str );
	Found.GetLastWriteTime( Time );
	m_Found.Add( Time.Format( "%I:%M %p") );

	m_CriticalSection.Unlock();

	AfxGetMainWnd()->PostMessage( WM_MYFOUND );
}
