// PNCommandSocket.cpp : implementation file
//

#include "stdafx.h"
#include "PNCommandSocket.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCPNCommandSocket

CPNCommandSocket::CPNCommandSocket(int TimeOutms )
{
	SetTimeOut( TimeOutms );
}



// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CPNCommandSocket, CASyncSocket)
	//{{AFX_MSG_MAP(CPNCommandSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CPNCommandSocket member functions


bool CPNCommandSocket::SendCommand(const char *Command, const char *Data, CString* Dest, const char *OK )
{
	int i, Len;
	CString sCommand, LocalDest;

	if( Dest == 0 )
		Dest = &LocalDest;

	if( Command && *Command )
	{
		sCommand.Format( Command, Data );

		TRACE( "Send Command-> %-128.128s\n", (LPCSTR)sCommand);
		Len = sCommand.GetLength();
		i=0;
		if( Send( (LPCSTR)sCommand+i, Len-i ) ==0 )
			return( false );
	}
	else
	{
		TRACE( "Send Command-> NULL\n", (LPCSTR)sCommand);
	}

	if( !OK )
		return( true );
	char* Buffer = Dest->GetBuffer( 2048 );

	i = ReceiveLine( Buffer, 2048);
	if( i <-0 )
		return(FALSE);

	TRACE( "Reply: %s\n", (LPCSTR)Buffer );
	Dest->ReleaseBuffer();
	if( OK )
		return( Dest->Find( OK, 0 )>=0 );
	
	return( TRUE );

}

