// MailerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Mailer.h"
#include "MailerDlg.h"

#include "ServerDlg.h"
#include "EMailDlg.h"

#include "PNPOP3.h"
#include "PNSMTP.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMailerDlg dialog

CMailerDlg::CMailerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMailerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMailerDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMailerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMailerDlg)
	DDX_Control(pDX, IDC_LIST, m_List);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMailerDlg, CDialog)
	//{{AFX_MSG_MAP(CMailerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SETUP, OnSetup)
	ON_BN_CLICKED(IDC_GETEMAIL, OnGetemail)
	ON_BN_CLICKED(IDC_SEND, OnSend)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMailerDlg message handlers

BOOL CMailerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CRect Rect;
	m_List.GetClientRect( Rect );
	m_List.InsertColumn( 0, "From" );
	m_List.InsertColumn( 1, "Subj" );
	m_List.InsertColumn( 2, "Date" );
	m_List.SetColumnWidth( 0, Rect.right/4 );
	m_List.SetColumnWidth( 1, Rect.right/2 );
	m_List.SetColumnWidth( 2, Rect.right/4 );
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMailerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMailerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMailerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMailerDlg::OnSetup() 
{
	CServerDlg Tmp;
	Tmp.m_Email = m_Email;
	Tmp.m_Login = m_Login;
	Tmp.m_Password = m_Password;
	Tmp.m_POP3Server = m_POP3Server;
	Tmp.m_SMTPServer = m_SMTPServer;

	if( Tmp.DoModal() )
	{
		m_Email=Tmp.m_Email;
		m_Login=Tmp.m_Login ;
		m_Password=Tmp.m_Password ;
		m_POP3Server=Tmp.m_POP3Server ;
		m_SMTPServer=Tmp.m_SMTPServer;
	}
}

void CMailerDlg::OnGetemail() 
{
	CPNPOP3 Pop3;
	CString Message, From, Subj, Date, *Store;
	int Row;

	CWaitCursor X;


	if( m_POP3Server.IsEmpty() )
	{
		MessageBox("Please setup POP3 server information before retrieving email");
		return;
	}
	
	try
	{
		Pop3.Connect( m_POP3Server, 110 );
		Pop3.Login( m_Login, m_Password );
		int i;
		for( i=m_List.GetItemCount()-1; i>=0; i-- )
			delete (CString*)m_List.GetItemData( i );
			
		i=Pop3.GetMsgCount();
		if( i==0 )
			MessageBox( "No Messages" );
		else
		{
			m_List.DeleteAllItems();
			for( int j=0; j < i; j++ )
			{
				if( !Pop3.GetMsg( j, Message ) )
				{
					MessageBox( "Error retrieving message" );
					break;
				}
				Pop3.ParseMsg( Message, From, Subj, Date );
				Store = new CString(Message);
				Row = m_List.InsertItem( m_List.GetItemCount(), From );
				m_List.SetItemData( Row, (DWORD)Store );
				m_List.SetItemText( Row, 1, Subj );
				m_List.SetItemText( Row, 2, Date );
			}
		}
		
	}
	catch( char* E )
	{
		MessageBox( E );
	}
	
}

void CMailerDlg::OnSend() 
{
	if( m_SMTPServer.IsEmpty() )
	{
		MessageBox("Please enter SMTP Server information in setup before attempting to send" );
		return;
	}

	CEMailDlg Tmp;
	
	if( Tmp.DoModal() == IDOK )
	{
		CPNSMTP SMTPServer;
		SMTPServer.Connect( m_SMTPServer );
		if( !SMTPServer.SendMail( m_Email, Tmp.m_Address, Tmp.m_Subject, Tmp.m_Message ) )
			MessageBox( SMTPServer.GetErrMsg(), "Error sending" );
	}

}

void CMailerDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i = m_List.GetNextItem( -1, LVNI_SELECTED );
	if( i>=0 )
	{
		CString* pString = (CString*)m_List.GetItemData( i );
		if( pString )
		{
			CEMailDlg Tmp;
			Tmp.m_Address = m_List.GetItemText( i, 0 );
			Tmp.m_Subject = m_List.GetItemText( i, 1 );
			Tmp.m_Message = *pString;
			Tmp.DoModal();
		}
	}

	*pResult = 0;
}
