// Mailer.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Mailer.h"
#include "MailerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMailerApp

BEGIN_MESSAGE_MAP(CMailerApp, CWinApp)
	//{{AFX_MSG_MAP(CMailerApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMailerApp construction

CMailerApp::CMailerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMailerApp object

CMailerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMailerApp initialization

BOOL CMailerApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	SetRegistryKey(_T("ProgrammersNotebook"));

	CMailerDlg dlg;
	dlg.m_POP3Server=GetProfileString( "Settings", "POP3Server", "" );
	dlg.m_SMTPServer=GetProfileString( "Settings", "SMTPServer", "" );
	dlg.m_Email=GetProfileString( "Settings", "EmailAddress", "" );
	dlg.m_Login=GetProfileString( "Settings", "Login", "" );
	dlg.m_Password = SimpleScramble( GetProfileString( "Settings", "Password", "" ), false );

	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	WriteProfileString( "Settings", "POP3Server", dlg.m_POP3Server );
	WriteProfileString( "Settings", "SMTPServer", dlg.m_SMTPServer );
	WriteProfileString( "Settings", "EmailAddress", dlg.m_Email );
	WriteProfileString( "Settings", "Login", dlg.m_Login );
	WriteProfileString( "Settings", "Password", SimpleScramble(dlg.m_Password, true) );


	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

CString CMailerApp::SimpleScramble(const char *Src, bool Scramble)
{
	// Very crude scramble logic, for storing sensitive data
	CString Ret, Tmp;
	unsigned int i;
	unsigned int j;
	static char List[]="0123456789ABCDEF";

	if( Scramble )
	{
		for( i=0; i < strlen(Src); i++ )
		{
			j = ~Src[i];
			Tmp.Format("%.02X%c", j&0xFF, List[rand()%16] );
			Ret += Tmp;
		}
	}
	else
	{
		for( i=0; i < strlen(Src); i+=3 )
		{
			if( Src[i] > '9' )
				j = (Src[i]-'A'+10) * 16;
			else
				j = (Src[i]-'0') * 16;
			if( Src[i+1] > '9' )
				j += (Src[i+1]-'A'+10);
			else
				j += (Src[i+1]-'0');
			j = ~j;
			Tmp.Format("%c", j );
			Ret += Tmp;
		}
	}
	return Ret;
}


