// IPRESTRICTION.CPP - Implementation file for your Internet Server
//    IPRestriction Filter

#include "stdafx.h"
#include "IPRestriction.h"

///////////////////////////////////////////////////////////////////////
// The one and only CWinApp object
// NOTE: You may remove this object if you alter your project to no
// longer use MFC in a DLL.

CWinApp theApp;



///////////////////////////////////////////////////////////////////////
// The one and only CIPRestrictionFilter object

CIPRestrictionFilter theFilter;


///////////////////////////////////////////////////////////////////////
// CIPRestrictionFilter implementation

CIPRestrictionFilter::CIPRestrictionFilter()
{
}

CIPRestrictionFilter::~CIPRestrictionFilter()
{
}

BOOL CIPRestrictionFilter::GetFilterVersion(PHTTP_FILTER_VERSION pVer)
{
	// Call default implementation for initialization
	CHttpFilter::GetFilterVersion(pVer);

	// Clear the flags set by base class
	pVer->dwFlags &= ~SF_NOTIFY_ORDER_MASK;

	// Set the flags we are interested in
	pVer->dwFlags |= SF_NOTIFY_ORDER_LOW | SF_NOTIFY_SECURE_PORT | SF_NOTIFY_NONSECURE_PORT
			 | SF_NOTIFY_URL_MAP;

	// Load description string
	TCHAR sz[SF_MAX_FILTER_DESC_LEN+1];
	ISAPIVERIFY(::LoadString(AfxGetResourceHandle(),
			IDS_FILTER, sz, SF_MAX_FILTER_DESC_LEN));
	_tcscpy(pVer->lpszFilterDesc, sz);
	return TRUE;
}

DWORD CIPRestrictionFilter::OnUrlMap(CHttpFilterContext* pCtxt,
	PHTTP_FILTER_URL_MAP pMapInfo)
{
	// TODO: React to this notification accordingly and
	// return the appropriate status code
	
	char RemoteHost[128];

	// Get IP of remote user
	DWORD Size=sizeof(RemoteHost);
	pCtxt->GetServerVariable( "REMOTE_ADDR", RemoteHost, &Size );

	// Load Text file with restricted IP addresses
	CFile IPs;

	bool Restricted=false;
	int Pos;
	if( IPs.Open( "c:\\inetpub\\wwwroot\\IPRestriction.lst", CFile::modeRead ) )
	{
		CArchive Ar( &IPs, CArchive::load );
		CString Line;
		while( Ar.ReadString( Line ) && !Restricted )
		{
			Pos = Line.Find( "*" );

			if( Pos > 0 )
				Line.Delete( Pos, Line.GetLength() - Pos );
			if( !Line.IsEmpty() && strncmp( RemoteHost, Line, Line.GetLength() ) == 0 )
				Restricted = true;
		}

		if( Restricted )
			strcpy( pMapInfo->pszPhysicalPath, "c:\\Inetpub\\wwwroot\\notallowed.html" );
	}

	return SF_STATUS_REQ_NEXT_NOTIFICATION;
}

// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CIPRestrictionFilter, CHttpFilter)
	//{{AFX_MSG_MAP(CIPRestrictionFilter)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

///////////////////////////////////////////////////////////////////////
// If your extension will not use MFC, you'll need this code to make
// sure the extension objects can find the resource handle for the
// module.  If you convert your extension to not be dependent on MFC,
// remove the comments arounn the following AfxGetResourceHandle()
// and DllMain() functions, as well as the g_hInstance global.

/****

static HINSTANCE g_hInstance;

HINSTANCE AFXISAPI AfxGetResourceHandle()
{
	return g_hInstance;
}

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ulReason,
					LPVOID lpReserved)
{
	if (ulReason == DLL_PROCESS_ATTACH)
	{
		g_hInstance = hInst;
	}

	return TRUE;
}

****/
