// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
// PN: Needed for CreateView function call on each view class
#include "HTMLLinks.h"
#include "HTMLLinksDoc.h"
#include "HTMLLinksView.h"
#include "PNCombobox.h"

#include "LinksView.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_COMMAND_EX(CG_ID_VIEW_MYDIALOGBAR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(CG_ID_VIEW_MYDIALOGBAR, OnUpdateControlBarMenu)
	//{{AFX_MSG_MAP(CMainFrame)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// TODO: Add a menu item that will toggle the visibility of the
	// dialog bar named "My Dialog Bar":
	//   1. In ResourceView, open the menu resource that is used by
	//      the CMainFrame class
	//   2. Select the View submenu
	//   3. Double-click on the blank item at the bottom of the submenu
	//   4. Assign the new item an ID: CG_ID_VIEW_MYDIALOGBAR
	//   5. Assign the item a Caption: My Dialog Bar

	// TODO: Change the value of CG_ID_VIEW_MYDIALOGBAR to an appropriate value:
	//   1. Open the file resource.h
	// CG: The following block was inserted by the 'Dialog Bar' component
	{
		// Initialize dialog bar m_wndMyDialogBar
		if (!m_wndMyDialogBar.Create(this, CG_IDD_MYDIALOGBAR,
			CBRS_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_HIDE_INPLACE,
			CG_ID_VIEW_MYDIALOGBAR))
		{
			TRACE0("Failed to create dialog bar m_wndMyDialogBar\n");
			return -1;		// fail to create
		}

		m_wndMyDialogBar.EnableDocking(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);
		EnableDocking(CBRS_ALIGN_ANY);
		DockControlBar(&m_wndMyDialogBar);

	}
	m_DialogBarCB.SetThisRegistrySave( true );
	m_DialogBarCB.SubclassDlgItem( IDC_URL, &m_wndMyDialogBar );

	return 0;
}

BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT /*lpcs*/,
	CCreateContext* pContext)
{
	// PN: Change Splitter to a static splitter, and make the panes
	// a ListView and a HTMLView window.
	m_wndSplitter.CreateStatic( this, 1, 2 );
	m_wndSplitter.CreateView( 0, 0, RUNTIME_CLASS(CLinksView), CSize( 100, 100 ), pContext );
	
	// Setup the List View control
	CListView* pListView = (CListView*)m_wndSplitter.GetPane(0,0);
	pListView->GetListCtrl().ModifyStyle( 0, LVS_REPORT );
	pListView->GetListCtrl().InsertColumn( 0, "Links" );
	pListView->GetListCtrl().SetColumnWidth( 0, 1000 );

	m_wndSplitter.CreateView( 0, 1, RUNTIME_CLASS(CHTMLLinksView), CSize( 100, 100 ), pContext );
	return TRUE;

/*	return m_wndSplitter.Create(this,
		2, 2,               // TODO: adjust the number of rows, columns
		CSize(10, 10),      // TODO: adjust the minimum pane size
		pContext);
*/
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style &=~(FWS_PREFIXTITLE|FWS_ADDTOTITLE);

	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::CBNavigate()
{
	// Add current string to combo box, in case not already there
	m_DialogBarCB.AddString();

	// Get current text from the combo box:
	CString Text;
	int Index = m_DialogBarCB.GetCurSel();
	if( Index >= 0 )
		m_DialogBarCB.GetLBText( Index, Text );
	else
		m_DialogBarCB.GetWindowText( Text );

	CHTMLLinksView* pView = (CHTMLLinksView*)m_wndSplitter.GetPane(0,1);
	pView->Navigate( Text );

}

void CMainFrame::SetURL(const char* URL)
{
	m_DialogBarCB.SetWindowText( URL );
}

CString CMainFrame::GetURL()
{
	// Retrieve current string from the URL combo box
	CString URL;
	m_DialogBarCB.GetWindowText( URL );

	return( URL );
}

CListCtrl* CMainFrame::GetListCtrl()
{
	// Return pointer to the List Control of the right pane CLinkView
	CListView* pList = (CListView*)m_wndSplitter.GetPane(0,0);
	return( &pList->GetListCtrl() );
}

