// HTMLLinksView.cpp : implementation of the CHTMLLinksView class
//

#include "stdafx.h"
#include "HTMLLinks.h"

#include "HTMLLinksDoc.h"
#include "HTMLLinksView.h"

#include "LinksView.h"
#include "MainFrm.h"
 
#include "Mshtml.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHTMLLinksView

IMPLEMENT_DYNCREATE(CHTMLLinksView, CHtmlView)

BEGIN_MESSAGE_MAP(CHTMLLinksView, CHtmlView)
	//{{AFX_MSG_MAP(CHTMLLinksView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE( IDC_URL, OnSelChangedURL )
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHTMLLinksView construction/destruction

CHTMLLinksView::CHTMLLinksView()
{
	// TODO: add construction code here

}

CHTMLLinksView::~CHTMLLinksView()
{
}

BOOL CHTMLLinksView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CHtmlView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CHTMLLinksView drawing

void CHTMLLinksView::OnDraw(CDC* pDC)
{
	CHTMLLinksDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

void CHTMLLinksView::OnInitialUpdate()
{
	CHtmlView::OnInitialUpdate();

	// TODO: This code navigates to a popular spot on the web.
	//  change the code to go where you'd like.
	Navigate2(_T("http://www.microsoft.com/visualc/"),NULL,NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CHTMLLinksView diagnostics

#ifdef _DEBUG
void CHTMLLinksView::AssertValid() const
{
	CHtmlView::AssertValid();
}

void CHTMLLinksView::Dump(CDumpContext& dc) const
{
	CHtmlView::Dump(dc);
}

CHTMLLinksDoc* CHTMLLinksView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHTMLLinksDoc)));
	return (CHTMLLinksDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHTMLLinksView message handlers



void CHTMLLinksView::OnDocumentComplete(LPCTSTR lpszURL) 
{
	// OnDocumentComplete is called when the HTML web page is
	// finished loading.

	CHtmlView::OnDownloadComplete();

	// PN: IHTMLDocument2 is a COM object provided by Microsoft Internet Explorer
	// that gives us access to the HTML document contained in an HTML Window (like
	// our CHTMLLinksView class)
	// Get the COM IDispatch (or, LPDISPATCH) for the current document
	IHTMLDocument2* pDoc = (IHTMLDocument2*)GetHtmlDocument();

	// Get the Body of the HTML document
	IHTMLElement* pBody;
	pDoc->get_body( &pBody );

	// Get the HTML text for the document body, into a BSTR
	BSTR Body;
	pBody->get_outerHTML( &Body );

	// Move the BSTR COM data type into a CString
	CString Page( Body );
	::SysFreeString( Body );

	// Temporary string variable for extracting links
	CString Link;

	// Get pointer to the Mainframe class, and the Lst control opn the left
	CMainFrame* pMain = (CMainFrame*)AfxGetMainWnd();
	CListCtrl* pList = pMain->GetListCtrl();

	// Delete the items currently on the left ListView
	pList->DeleteAllItems();

	// Start parsing the HTML text looking for links (Start with '<A')
	int Index;
	while( (Index = Page.Find( '<' )) >=0 )
	{
		Link.Empty();
		Page.Delete(0, Index+1 );

		if( Page.GetLength() > 8 && toupper(Page[0])=='A' && Page[1]==' ' )
		{
			Index = Page.Find( '"' );
			if( Index >=0 )
			{
				Page.Delete(0, Index+1);
				while( !Page.IsEmpty() && Page[0] != '"' )
				{
					Link += Page[0];
					Page.Delete(0);
				}
				if( Link.Find(".") < 0 || (Link.Find( "." ) > Link.Find("/") && Link.Find( "http:") != 0) )
				{
					CString Home = GetLocationURL();
					if( Home[ Home.GetLength()-1 ] == '/' && Link[0]=='/' )
						Link.Delete(0);
					Link = Home + Link;
				}
				pList->InsertItem( pList->GetItemCount(), Link );
			}
		}

	}
	pMain->SetURL( GetLocationURL() );

	CHtmlView::OnDocumentComplete(lpszURL);
}

void CHTMLLinksView::OnSelChangedURL( )
{
	CMainFrame* pMain = (CMainFrame*)AfxGetMainWnd();
	pMain->CBNavigate();
	TRACE( "CLinksView::OnSelChangedURL\n" );
}
