// ColorCGI.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ColorCGI.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

char InputData[4096];

//PN: Get CGI Parameters, all of them, whether POST or GET
void PNGetAllParams()
{
	// Determing if was a POST or GET method
	if( getenv( "REQUEST_METHOD" ) == 0 )
	{
		cout << "No REQUEST_METHOD, must be running in DOS mode" << endl;
		return;
	}
	if( strcmp( getenv("REQUEST_METHOD"), "POST" ) == 0 )
	{
		// If POST, then get data from
		int InputLength = atoi( getenv("CONTENT_LENGTH") ); 
		cin.read( InputData, InputLength );
	}
	else
		strcpy( InputData, getenv( "QUERY_STRING" ) );
}

// PN: Extract s single CGI parameter
int PNGetParam( const char * Name, CString& Dest, const char* Default )
{
	Dest.Empty();

	// Helper macro to convert two-character hex strings to character value
#define ToHex(Y) (Y>='0'&&Y<='9'?Y-'0':Y-'A'+10)
	// Search for the desired parameter name in InputData
	char* pArg = strstr( InputData, Name );
	if( pArg ) // If found
	{
		// Go to the start of the parameter
		pArg += strlen(Name);
		if( *pArg == '=' )  // Make sure there is an '=' where we expect it
		{
			pArg++;
			// Loop until we hit the end of this parameter value
			while( *pArg && *pArg != '&' )
			{
				// If the character is a '%', that means 2-character hex value follows
				if( *pArg == '%' )
				{
					// Convert it to a single ASCII character and store at our destination
					Dest += (char)ToHex(pArg[1]) * 16 + ToHex(pArg[2]);
					pArg += 3;
				}
				else
					if( *pArg=='+' ) // If it's a '+', store a space at our destination
					{
						Dest += ' ';
						pArg++;
					}
					else
						Dest += *pArg++; // Otherwise, just store the character at our destination
			}
			return(1);
		}
	}
	Dest = Default; // If param not found, then use default parameter
	return(0);
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// Output standard HTML CGI header
	cout << "Content-type: text/html\n\n";
	cout << "<HTML><BODY>" << endl;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << "Fatal Error: MFC initialization failed<P>" << endl;
	}
	else
	{
		// TODO: code your application's behavior here.
		PNGetAllParams();
		CString UsersColor;
		PNGetParam( "Color", UsersColor, "" );
		if( UsersColor.IsEmpty() )
			cout << "Hey, enter a color!" << endl;
		else
		{
			if( UsersColor.CompareNoCase( "blue" )==0 )
				cout << "Cool, I like blue also"<< endl;
			else
				cout << (LPCSTR) UsersColor << " is nice, but I prefer blue" << endl;
		}


	}

	// Output standard HTML CGI footer
	cout << "</HTML></BODY>" << endl;

	return nRetCode;
}


