// TradeSet.cpp : implementation file
//

#include "stdafx.h"
#include "ODBC_Stock.h"
#include "TradeSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTradeSet

IMPLEMENT_DYNAMIC(CTradeSet, CRecordset)

CTradeSet::CTradeSet(CDatabase* pdb)
	: CRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CTradeSet)
	m_Change = 0.0;
	m_Price = 0.0;
	m_StockID = 0;
	m_TradeID = 0;
	m_nFields = 5;
	//}}AFX_FIELD_INIT
	m_nDefaultType = snapshot;

	// Initialize m_TradeDate.  This is a documented fix in MS aricle Q155721.
	m_TradeDate = CTime::GetCurrentTime();
}


CString CTradeSet::GetDefaultConnect()
{
	return _T("ODBC;DSN=PNStocks");
}

CString CTradeSet::GetDefaultSQL()
{
	return _T("[Trade]");
}

void CTradeSet::DoFieldExchange(CFieldExchange* pFX)
{

	//{{AFX_FIELD_MAP(CTradeSet)
	pFX->SetFieldType(CFieldExchange::outputColumn);
	RFX_Double(pFX, _T("[Change]"), m_Change);
	RFX_Double(pFX, _T("[Price]"), m_Price);
	RFX_Long(pFX, _T("[StockID]"), m_StockID);
	RFX_Date(pFX, _T("[TradeDate]"), m_TradeDate);
	RFX_Long(pFX, _T("[TradeID]"), m_TradeID);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CTradeSet diagnostics

#ifdef _DEBUG
void CTradeSet::AssertValid() const
{
	CRecordset::AssertValid();
}

void CTradeSet::Dump(CDumpContext& dc) const
{
	CRecordset::Dump(dc);
}
#endif //_DEBUG

bool CTradeSet::Select(int StockID)
{
	// Helper function to select the trades for a specific Stock ID
	
	// If the table is already open, then close it
	if( IsOpen() )
		Close();
	
	// Set selection critieria
	m_strFilter.Format( "StockID=%d", StockID );
	
	// Set sort order
	m_strSort="TradeDate";
	
	// Open the table
	Open();

	return( IsEOF()? false : true );
}

int CTradeSet::GetNextID()
{
	// Helper function that determines the next Unique ID for the Trade
	// table in the database.  It uses the TableIDs table and recordset
	// to determine the next ID
	CTableIDs Tmp;
	m_TradeID = Tmp.GetNextID( GetDefaultSQL() );
	return( m_TradeID );
}
