// TradeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ODBC_Stock.h"
#include "TradeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTradeDlg dialog


CTradeDlg::CTradeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTradeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTradeDlg)
	m_pSet = NULL;
	//}}AFX_DATA_INIT
}


void CTradeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTradeDlg)
	DDX_FieldText(pDX, IDC_CHANGE, m_pSet->m_Change, m_pSet);
	DDX_FieldText(pDX, IDC_PRICE, m_pSet->m_Price, m_pSet);
	DDX_DateTimeCtrl(pDX, IDC_DATE, m_pSet->m_TradeDate);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTradeDlg, CDialog)
	//{{AFX_MSG_MAP(CTradeDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTradeDlg message handlers

int CTradeDlg::DoModal(CTradeSet& TradeSet, bool IsAdd, int StockID ) 
{
	
	m_pSet = &TradeSet;
	if( !m_pSet->IsOpen() )
		m_pSet->Open();
	if( IsAdd )
	{
		m_pSet->AddNew();
		m_pSet->m_TradeDate = CTime::GetCurrentTime();
		m_pSet->m_StockID = StockID;
		m_pSet->GetNextID();
	}
	else
		m_pSet->Edit();
	m_IsNew = IsAdd;

	return CDialog::DoModal();
}

BOOL CTradeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CDateTimeCtrl* pDate = (CDateTimeCtrl*)GetDlgItem( IDC_DATE );

	pDate->SetFormat( "MM'/'dd'/'yyyy' 'hh':'mm' 'tt" );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTradeDlg::OnOK() 
{
	//Move data from on screen controls to mapped variables
	UpdateData();
	
	// Move data from recordset to disk file (table)
	m_pSet->Update();

	CDialog::OnOK();
}

void CTradeDlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	m_pSet->CancelUpdate();

	CDialog::OnCancel();
}
