// StockDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ODBC_Stock.h"
#include "StockDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStockDlg dialog


CStockDlg::CStockDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStockDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStockDlg)
	m_pSet = NULL;
	//}}AFX_DATA_INIT
}


void CStockDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStockDlg)
	DDX_FieldText(pDX, IDC_COMPANY, m_pSet->m_Company, m_pSet);
	DDX_FieldText(pDX, IDC_EXCHANGE, m_pSet->m_Exchange, m_pSet);
	DDX_FieldText(pDX, IDC_INDUSTRY, m_pSet->m_Industry, m_pSet);
	DDX_FieldText(pDX, IDC_SYMBOL, m_pSet->m_Symbol, m_pSet);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStockDlg, CDialog)
	//{{AFX_MSG_MAP(CStockDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStockDlg message handlers

void CStockDlg::OnOK() 
{
	// Move data from on-screen controls into member variables
	UpdateData();

	int NewID;
	
	// If this is a Stock addition, get the next Stock ID
	if( m_IsNew )
		NewID = m_pSet->GetNextID();

	// Update the record (doesn't matter if AddNew or Edit)
	m_pSet->Update();

	if( m_IsNew )
	{
		// If a newly-added record, go right back to it.
		m_pSet->m_strFilter.Format( "StockID=%d", NewID );
		m_pSet->Requery();
	}
	
	// Call default OnOk handler, to close the dialog
	CDialog::OnOK();
}

void CStockDlg::OnCancel() 
{
	// Cancel Edit or AddNew on m_pSet
	m_pSet->CancelUpdate();
	m_pSet->Close();
	
	CDialog::OnCancel();
}

int CStockDlg::DoModal( CStockSet& Set, bool IsAdd ) 
{
	// This is our overloaded DoModal function

	// Setup our m_pSet variable with the passed recordset.
	m_pSet = &Set;

	// If the record set isn't open, then open it
	if( !m_pSet->IsOpen() )
		m_pSet->Open();
	
	// If IsAdd is true, then we should add a new record, otherwise
	// we are being asked to edit the current record
	if( IsAdd )
		m_pSet->AddNew();
	else
		m_pSet->Edit();

	// Save the IsAdd parameter in member variable, for the OnOk function
	m_IsNew = IsAdd;

	// Call base class DoModal to display the dialog
	return CDialog::DoModal();
}
