// PortfolioSet.cpp : implementation file
//

#include "stdafx.h"
#include "ODBC_Stock.h"
#include "PortfolioSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPortfolioSet

IMPLEMENT_DYNAMIC(CPortfolioSet, CRecordset)

CPortfolioSet::CPortfolioSet(CDatabase* pdb)
	: CRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CPortfolioSet)
	m_PortfolioID = 0;
	m_Shares = 0;
	m_StockID = 0;
	m_PurchasePrice = 0.0;
	m_nFields = 5;
	//}}AFX_FIELD_INIT
	m_nDefaultType = snapshot;

	// Initialize m_PurchaseDate.  This is a documented fix in MS aricle Q155721.
	m_PurchaseDate = CTime::GetCurrentTime();
}


CString CPortfolioSet::GetDefaultConnect()
{
	return _T("ODBC;DSN=PNStocks");
}

CString CPortfolioSet::GetDefaultSQL()
{
	return _T("[Portfolio]");
}

void CPortfolioSet::DoFieldExchange(CFieldExchange* pFX)
{

	//{{AFX_FIELD_MAP(CPortfolioSet)
	pFX->SetFieldType(CFieldExchange::outputColumn);
	RFX_Long(pFX, _T("[PortfolioID]"), m_PortfolioID);
	RFX_Date(pFX, _T("[PurchaseDate]"), m_PurchaseDate);
	RFX_Long(pFX, _T("[Shares]"), m_Shares);
	RFX_Long(pFX, _T("[StockID]"), m_StockID);
	RFX_Double(pFX, _T("[PurchasePrice]"), m_PurchasePrice);
	//}}AFX_FIELD_MAP

	
}

/////////////////////////////////////////////////////////////////////////////
// CPortfolioSet diagnostics

#ifdef _DEBUG
void CPortfolioSet::AssertValid() const
{
	CRecordset::AssertValid();
}

void CPortfolioSet::Dump(CDumpContext& dc) const
{
	CRecordset::Dump(dc);
}
#endif //_DEBUG

int CPortfolioSet::GetNextID()
{
	// Determine the next unique portfolio ID, using the CTableIDs recordset class
	CTableIDs Tmp;
	m_PortfolioID = Tmp.GetNextID( GetDefaultSQL() );
	return( m_PortfolioID );

}
