// ODBC_StockView.cpp : implementation of the CODBC_StockView class
//

#include "stdafx.h"
#include "ODBC_Stock.h"

#include "ODBC_StockDoc.h"
#include "ODBC_StockView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CODBC_StockView

IMPLEMENT_DYNCREATE(CODBC_StockView, CFormView)

BEGIN_MESSAGE_MAP(CODBC_StockView, CFormView)
	//{{AFX_MSG_MAP(CODBC_StockView)
	ON_WM_SIZE()
	ON_NOTIFY(TCN_SELCHANGE, IDC_STOCKTAB, OnSelchangeStocktab)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CODBC_StockView construction/destruction

CODBC_StockView::CODBC_StockView()
	: CFormView(CODBC_StockView::IDD)
{
	//{{AFX_DATA_INIT(CODBC_StockView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CODBC_StockView::~CODBC_StockView()
{
}

void CODBC_StockView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CODBC_StockView)
	DDX_Control(pDX, IDC_STOCKTAB, m_Tab);
	//}}AFX_DATA_MAP
}

BOOL CODBC_StockView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CODBC_StockView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	// Setup Tab control
	static bool Once=false;
	if( !Once )
	{
		Once = true;
		// Insert 2 Tabs named Stock and Portolio
		m_Tab.InsertItem(0, "Stock" );
		m_Tab.InsertItem(1, "Portfolio" );

		// Create tab pages from the Dialog classes
		CRect Rect;
		m_Tab.GetItemRect( 0, &Rect );

		// Create the Stock page, as a child of the tab control
		m_StockPage.Create( IDD_STOCKPAGE, &m_Tab );
		m_StockPage.SetWindowPos( 0, Rect.left+2, Rect.bottom+2, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
		m_StockPage.ShowWindow( SW_NORMAL );

		// Create the Portfolio page, as a child of the tab control (hidden)
		m_PortfolioPage.Create( IDD_PORTFOLIOPAGE, &m_Tab );
		m_PortfolioPage.SetWindowPos( 0, Rect.left+2, Rect.bottom+2, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
		m_PortfolioPage.ShowWindow( SW_HIDE );

	}

}

/////////////////////////////////////////////////////////////////////////////
// CODBC_StockView diagnostics

#ifdef _DEBUG
void CODBC_StockView::AssertValid() const
{
	CFormView::AssertValid();
}

void CODBC_StockView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CODBC_StockDoc* CODBC_StockView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CODBC_StockDoc)));
	return (CODBC_StockDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CODBC_StockView message handlers

void CODBC_StockView::OnSize(UINT nType, int cx, int cy) 
{

	CFormView::OnSize(nType, cx, cy);
	// Size the tab control to fit the window
	if( m_Tab.GetSafeHwnd() )
		m_Tab.SetWindowPos( 0, 0, 0, cx, cy, SWP_NOZORDER|SWP_NOMOVE );
	
}

void CODBC_StockView::OnSelchangeStocktab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// When user clicks a tab, hide one Tab page and show the other
	int Index = m_Tab.GetCurSel();

	if( Index == 0 ) // Stock Page
	{
		m_PortfolioPage.UpdateData();
		m_PortfolioPage.ShowWindow( SW_HIDE );
		m_StockPage.ShowWindow( SW_NORMAL );
	}
	else
	{
		m_StockPage.UpdateData();
		m_StockPage.ShowWindow( SW_HIDE );
		m_PortfolioPage.ShowWindow( SW_NORMAL );
		m_PortfolioPage.RefreshData();
	}
	*pResult = 0;
}

// Printing Section.
// Here, we will use each of the View-implemented printing routines
// to call the function with the same name in the dialogs that represent
// the currently selected Tab page.  This way, the user has 2 reports,
// determined by the currently-selected tab page.  Note how each function
// determines the currect tab page before invoking the same function
// in 1 of the two possible Tab page classes (m_StockPage and m_PortfolioPage
void CODBC_StockView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnBeginPrinting( pDC, pInfo );
	else
		m_PortfolioPage.OnBeginPrinting( pDC, pInfo );
	
	CFormView::OnBeginPrinting(pDC, pInfo);
}

BOOL CODBC_StockView::OnPreparePrinting(CPrintInfo* pInfo) 
{
	if( m_Tab.GetCurSel() == 0 ) 
	{
		if( m_StockPage.OnPreparePrinting(pInfo) == FALSE )
			return( FALSE );
	}
	else
		if( m_PortfolioPage.OnPreparePrinting(pInfo) == FALSE )
			return( FALSE );
	
	return DoPreparePrinting(pInfo);
}

void CODBC_StockView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	if( pInfo )
	{
		if( m_Tab.GetCurSel() == 0 ) 
			m_StockPage.OnPrepareDC(pDC, pInfo);
		else
			m_PortfolioPage.OnPrepareDC(pDC, pInfo);
	}
	
}

void CODBC_StockView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnPrint( pDC, pInfo );
	else
		m_PortfolioPage.OnPrint( pDC, pInfo );
	
	CFormView::OnPrint(pDC, pInfo);
}

void CODBC_StockView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnEndPrinting( pDC, pInfo );
	else
		m_PortfolioPage.OnEndPrinting( pDC, pInfo );
	
	CFormView::OnEndPrinting(pDC, pInfo);
}
