// TradeSet.cpp : implementation file
//

#include "stdafx.h"
#include "DAO_Stock.h"
#include "TradeSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTradeSet

IMPLEMENT_DYNAMIC(CTradeSet, CDaoRecordset)

CTradeSet::CTradeSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CTradeSet)
	m_TradeID = 0;
	m_StockID = 0;
	m_TradeDate = (DATE)0;
	m_Price = 0.0;
	m_Change = 0.0;
	m_nFields = 5;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;

	// Initialize m_TradeDate.  This is a documented fix in MS aricle Q155721.
	m_TradeDate = COleDateTime::GetCurrentTime();
}


CString CTradeSet::GetDefaultDBName()
{
	return _T("..\\PNStocks.mdb");}

CString CTradeSet::GetDefaultSQL()
{
	return _T("[Trade]");
}

void CTradeSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CTradeSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Long(pFX, _T("[TradeID]"), m_TradeID);
	DFX_Long(pFX, _T("[StockID]"), m_StockID);
	DFX_DateTime(pFX, _T("[TradeDate]"), m_TradeDate);
	DFX_Double(pFX, _T("[Price]"), m_Price);
	DFX_Double(pFX, _T("[Change]"), m_Change);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CTradeSet diagnostics

#ifdef _DEBUG
void CTradeSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CTradeSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG

bool CTradeSet::Select(int StockID)
{
	// Helper function to select the trades for a specific Stock ID
	
	// If the table is already open, then close it
	if( IsOpen() )
		Close();
	
	// Set selection critieria
	m_strFilter.Format( "StockID=%d", StockID );
	
	// Set sort order
	m_strSort="TradeDate";
	
	// Open the table
	Open();

	return( IsEOF()? false : true );

}

int CTradeSet::GetNextID()
{
	// Helper function that determines the next Unique ID for the Trade
	// table in the database.  It uses the TableIDs table and recordset
	// to determine the next ID
	CTableIDs Tmp;
	m_TradeID = Tmp.GetNextID( GetDefaultSQL() );
	return( m_TradeID );

}
