// StockSet.cpp : implementation file
//

#include "stdafx.h"
#include "DAO_Stock.h"
#include "StockSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStockSet

IMPLEMENT_DYNAMIC(CStockSet, CDaoRecordset)

CStockSet::CStockSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CStockSet)
	m_StockID = 0;
	m_Symbol = _T("");
	m_Company = _T("");
	m_Exchange = _T("");
	m_Industry = _T("");
	m_nFields = 5;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;
}


CString CStockSet::GetDefaultDBName()
{
	return _T("..\\PNStocks.mdb");}

CString CStockSet::GetDefaultSQL()
{
	return _T("[Stock]");
}

void CStockSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CStockSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Long(pFX, _T("[StockID]"), m_StockID);
	DFX_Text(pFX, _T("[Symbol]"), m_Symbol);
	DFX_Text(pFX, _T("[Company]"), m_Company);
	DFX_Text(pFX, _T("[Exchange]"), m_Exchange);
	DFX_Text(pFX, _T("[Industry]"), m_Industry);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CStockSet diagnostics

#ifdef _DEBUG
void CStockSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CStockSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG

double CStockSet::GetLatestPrice(int StockID)
{
// Helper function for the Stock table in the database, to determine
	// what the latest stock price is, based on the trades.  Note that
	// it demonstrates how to search (m_strFilter) and sort (m_strSort)
	// a database table.
	if( StockID == -1 )
		StockID = m_StockID;

	CTradeSet Tmp;
	// Set the database table filter to the unique StockID
	Tmp.m_strFilter.Format( "StockID=%d", StockID );
	// Set the database table sort specifier to use the TradeDate field
	// in DESCending order
	Tmp.m_strSort = "TradeDate DESC";

	// Open the table
	Tmp.Open();

	// If IsEOP is true, then there are no records
	if( Tmp.IsEOF() )
		return( 0.0 );
	else
		return( Tmp.m_Price ); // Otherwise we can return the price found
}

int CStockSet::GetNextID()
{
	// Helper function that determines the next Unique ID for the Stock
	// table in the database.  It uses the TableIDs table and recordset
	// to determine the next ID
	CTableIDs Tmp;
	m_StockID = Tmp.GetNextID( GetDefaultSQL() );
	return( m_StockID );

}

bool CStockSet::Lookup(int ID)
{
	// Helper function to lookup a stock by its unique Stock ID
	if( IsOpen() )
		Close();
	m_strFilter.Format( "StockID=%d", ID );
	Open();
	return( IsEOF() ? false : true );

}
