// PortfolioSet.cpp : implementation file
//

#include "stdafx.h"
#include "DAO_Stock.h"
#include "PortfolioSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPortfolioSet

IMPLEMENT_DYNAMIC(CPortfolioSet, CDaoRecordset)

CPortfolioSet::CPortfolioSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CPortfolioSet)
	m_PortfolioID = 0;
	m_StockID = 0;
	m_PurchaseDate = (DATE)0;
	m_PurchasePrice = 0.0;
	m_Shares = 0;
	m_nFields = 5;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;
}


CString CPortfolioSet::GetDefaultDBName()
{
	return _T("..\\PNStocks.mdb");
}

CString CPortfolioSet::GetDefaultSQL()
{
	return _T("[Portfolio]");
}

void CPortfolioSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CPortfolioSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Long(pFX, _T("[PortfolioID]"), m_PortfolioID);
	DFX_Long(pFX, _T("[StockID]"), m_StockID);
	DFX_DateTime(pFX, _T("[PurchaseDate]"), m_PurchaseDate);
	DFX_Double(pFX, _T("[PurchasePrice]"), m_PurchasePrice);
	DFX_Long(pFX, _T("[Shares]"), m_Shares);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CPortfolioSet diagnostics

#ifdef _DEBUG
void CPortfolioSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CPortfolioSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG


int CPortfolioSet::GetNextID()
{
		// Determine the next unique portfolio ID, using the CTableIDs recordset class
	CTableIDs Tmp;
	m_PortfolioID = Tmp.GetNextID( GetDefaultSQL() );
	return( m_PortfolioID );
}