// DAO_StockView.cpp : implementation of the CDAO_StockView class
//

#include "stdafx.h"
#include "DAO_Stock.h"

#include "DAO_StockDoc.h"
#include "DAO_StockView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDAO_StockView

IMPLEMENT_DYNCREATE(CDAO_StockView, CFormView)

BEGIN_MESSAGE_MAP(CDAO_StockView, CFormView)
	//{{AFX_MSG_MAP(CDAO_StockView)
	ON_NOTIFY(TCN_SELCHANGE, IDC_STOCKTAB, OnSelchangeStocktab)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDAO_StockView construction/destruction

CDAO_StockView::CDAO_StockView()
	: CFormView(CDAO_StockView::IDD)
{
	//{{AFX_DATA_INIT(CDAO_StockView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CDAO_StockView::~CDAO_StockView()
{
}

void CDAO_StockView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDAO_StockView)
	DDX_Control(pDX, IDC_STOCKTAB, m_Tab);
	//}}AFX_DATA_MAP
}

BOOL CDAO_StockView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CDAO_StockView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	// Setup Tab control
	static bool Once=false;
	if( !Once )
	{
		Once = true;
		// Insert 2 Tabs named Stock and Portolio
		m_Tab.InsertItem(0, "Stock" );
		m_Tab.InsertItem(1, "Portfolio" );

		// Create tab pages from the Dialog classes
		CRect Rect;
		m_Tab.GetItemRect( 0, &Rect );

		// Create the Stock page, as a child of the tab control
		m_StockPage.Create( IDD_STOCKPAGE, &m_Tab );
		m_StockPage.SetWindowPos( 0, Rect.left+2, Rect.bottom+2, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
		m_StockPage.ShowWindow( SW_NORMAL );

		// Create the Portfolio page, as a child of the tab control (hidden)
		m_PortfolioPage.Create( IDD_PORTFOLIOPAGE, &m_Tab );
		m_PortfolioPage.SetWindowPos( 0, Rect.left+2, Rect.bottom+2, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
		m_PortfolioPage.ShowWindow( SW_HIDE );

	}

}

/////////////////////////////////////////////////////////////////////////////
// CDAO_StockView printing

BOOL CDAO_StockView::OnPreparePrinting(CPrintInfo* pInfo)
{
	if( m_Tab.GetCurSel() == 0 ) 
	{
		if( m_StockPage.OnPreparePrinting(pInfo) == FALSE )
			return( FALSE );
	}
	else
		if( m_PortfolioPage.OnPreparePrinting(pInfo) == FALSE )
			return( FALSE );

	return DoPreparePrinting(pInfo);
}

void CDAO_StockView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnBeginPrinting( pDC, pInfo );
	else
		m_PortfolioPage.OnBeginPrinting( pDC, pInfo );
	
	CFormView::OnBeginPrinting(pDC, pInfo);
}

void CDAO_StockView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnEndPrinting( pDC, pInfo );
	else
		m_PortfolioPage.OnEndPrinting( pDC, pInfo );
	
	CFormView::OnEndPrinting(pDC, pInfo);
}

void CDAO_StockView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	if( pInfo )
	{
		if( m_Tab.GetCurSel() == 0 ) 
			m_StockPage.OnPrepareDC(pDC, pInfo);
		else
			m_PortfolioPage.OnPrepareDC(pDC, pInfo);
	}
	
	CFormView::OnPrepareDC(pDC, pInfo);
}

void CDAO_StockView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	if( m_Tab.GetCurSel() == 0 ) 
		m_StockPage.OnPrint( pDC, pInfo );
	else
		m_PortfolioPage.OnPrint( pDC, pInfo );
	
	CFormView::OnPrint(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CDAO_StockView diagnostics

#ifdef _DEBUG
void CDAO_StockView::AssertValid() const
{
	CFormView::AssertValid();
}

void CDAO_StockView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CDAO_StockDoc* CDAO_StockView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDAO_StockDoc)));
	return (CDAO_StockDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDAO_StockView message handlers

void CDAO_StockView::OnSelchangeStocktab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// When user clicks a tab, hide one Tab page and show the other
	int Index = m_Tab.GetCurSel();

	if( Index == 0 ) // Stock Page
	{
		m_PortfolioPage.UpdateData();
		m_PortfolioPage.ShowWindow( SW_HIDE );
		m_StockPage.ShowWindow( SW_NORMAL );
	}
	else
	{
		m_StockPage.UpdateData();
		m_StockPage.ShowWindow( SW_HIDE );
		m_PortfolioPage.ShowWindow( SW_NORMAL );
		m_PortfolioPage.RefreshData();
	}
	*pResult = 0;
}

void CDAO_StockView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);
	
	if( m_Tab.GetSafeHwnd() )
		m_Tab.SetWindowPos( 0, 0, 0, cx, cy, SWP_NOZORDER|SWP_NOMOVE );
	
}

