// TradeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ADO_Stock.h"
#include "TradeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTradeDlg dialog


CTradeDlg::CTradeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTradeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTradeDlg)
	m_Date = COleDateTime::GetCurrentTime();
	m_Change = 0.0;
	m_Price = 0.0;
	//}}AFX_DATA_INIT
}


void CTradeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTradeDlg)
	DDX_DateTimeCtrl(pDX, IDC_DATE, m_Date);
	DDX_Text(pDX, IDC_CHANGE, m_Change);
	DDX_Text(pDX, IDC_PRICE, m_Price);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTradeDlg, CDialog)
	//{{AFX_MSG_MAP(CTradeDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTradeDlg message handlers

int CTradeDlg::DoModal(CPNADORecordset& TradeSet, bool IsAdd, int StockID) 
{
	m_TradeSet = TradeSet;

	if( !(m_TradeSet->GetState() & adStateOpen ) )
		m_TradeSet.PNOpen( "Trade" );

	if( IsAdd )
	{
		m_TradeSet->AddNew();
		m_TradeSet.PNSetField( "StockID", StockID );
	}
	else
	{
		m_TradeSet.PNGetField( "Change", m_Change );
		m_TradeSet.PNGetField( "Price", m_Price );
		m_TradeSet.PNGetField( "TradeDate", m_Date );
	}

	m_IsNew = IsAdd;


	return CDialog::DoModal();
}

void CTradeDlg::OnOK() 
{
	// Bring data from on screen controls to member variables
	UpdateData();

	// For new records, get next unique ID
	if( m_IsNew )
		m_TradeSet.PNSetField( "TradeID", m_TradeSet.PNGetNextID("Trade") );

	// Move data from member variables into recordset
	m_TradeSet.PNSetField( "Change", m_Change );
	m_TradeSet.PNSetField( "Price", m_Price );
	m_TradeSet.PNSetField( "TradeDate", m_Date );
	// StockID was already set in the DoModal function

	// Update the recordset (either an insert or an edit)
	try
	{
	m_TradeSet->Update();
	} 
	catch( _com_error* pE )
	{
		MessageBox( pE->Description() );
	}
	
	CDialog::OnOK();
}

void CTradeDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CTradeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CDateTimeCtrl* pDate = (CDateTimeCtrl*)GetDlgItem( IDC_DATE );

	pDate->SetFormat( "MM'/'dd'/'yyyy' 'hh':'mm' 'tt" );

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
