// StockDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ADO_Stock.h"
#include "StockDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStockDlg dialog


CStockDlg::CStockDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStockDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStockDlg)
	m_Company = _T("");
	m_Exchange = _T("");
	m_Industry = _T("");
	m_Symbol = _T("");
	//}}AFX_DATA_INIT
}


void CStockDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStockDlg)
	DDX_Text(pDX, IDC_COMPANY, m_Company);
	DDX_Text(pDX, IDC_EXCHANGE, m_Exchange);
	DDX_Text(pDX, IDC_INDUSTRY, m_Industry);
	DDX_Text(pDX, IDC_SYMBOL, m_Symbol);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStockDlg, CDialog)
	//{{AFX_MSG_MAP(CStockDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStockDlg message handlers

int CStockDlg::DoModal(CPNADORecordset& StockSet, bool IsAdd ) 
{

	
	// If the record set isn't open, then open it
	if( ! (StockSet->GetState() & adStateOpen) )
		StockSet.PNOpen( "Stock" );
	
	// If IsAdd is true, then we should add a new record, otherwise
	// we are being asked to edit the current record
	if( IsAdd )
		StockSet->AddNew();
	else
	{
		// ADO does not require a call to an Edit function.  However,
		// we will manually transfer data to the edit boxes in edit mode.
		StockSet.PNGetField( "Company", m_Company );
		StockSet.PNGetField( "Exchange", m_Exchange );
		StockSet.PNGetField( "Symbol", m_Symbol );
		StockSet.PNGetField( "Industry", m_Industry );
	}

	// Save the IsAdd parameter in member variable, for the OnOk function
	m_IsNew = IsAdd;

	m_StockSet = StockSet;

	return CDialog::DoModal();
}

void CStockDlg::OnOK() 
{
	// Get data from screen to member variables.
	UpdateData( TRUE );

	// Manually, move member variables to record set
	if( m_IsNew )
		m_StockSet.PNSetField( "StockID", m_StockSet.PNGetNextID("Stock") );
	m_StockSet.PNSetField( "Company", m_Company );
	m_StockSet.PNSetField( "Exchange", m_Exchange );
	m_StockSet.PNSetField( "Symbol", m_Symbol );
	m_StockSet.PNSetField( "Industry", m_Industry );

	m_StockSet->Update();
	
	CDialog::OnOK();
}

void CStockDlg::OnCancel() 
{
	m_StockSet->CancelUpdate();
	
	CDialog::OnCancel();
}
