// PortfolioPage.cpp : implementation file
//

#include "stdafx.h"
#include "ADO_Stock.h"
#include "PortfolioPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPortfolioPage dialog


CPortfolioPage::CPortfolioPage(CWnd* pParent /*=NULL*/)
	: CDialog(CPortfolioPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortfolioPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPortfolioPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortfolioPage)
	DDX_Control(pDX, IDC_STOCKS, m_List);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPortfolioPage, CDialog)
	//{{AFX_MSG_MAP(CPortfolioPage)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortfolioPage message handlers

void CPortfolioPage::RefreshData()
{
	// Refresh the Portfolio page (which is really a dialog inside a tab control)
	CPNADORecordset PortfolioStockSet;
	CPNADORecordset TradeSet;
	int Index, StockID, PortfolioID, Shares;
	double Dbl;
	COleDateTime Date;
	CString Text;

	// Remove the contents of the Portfolio ListView control
	m_List.DeleteAllItems();
	

	// Open the portfolio table, and iterate through records
	PortfolioStockSet.PNOpen("Select * from Portfolio,Stock where Portfolio.StockID=Stock.StockID Order by PurchaseDate");
	while( !PortfolioStockSet->GetIsEOF() )
	{
		// Retrieve stock from the portfolio record
		PortfolioStockSet.PNGetField( "Stock.StockID", StockID );

		Text.Format( "select * from Trade where StockID = %d order by TradeDate DESC", StockID );
		TradeSet.PNOpen( Text );

		// Add entries to the List control, for the stock information
		// Note: This field has no table prefix, because it is not duplicated in results
		PortfolioStockSet.PNGetField( "Symbol", Text );
		Index = m_List.InsertItem( m_List.GetItemCount(), Text );

		// Save the Unique ID of the Portolio record in the List control
		// also, as 'Item Data'.
		PortfolioStockSet.PNGetField( "PortfolioID", PortfolioID );
		m_List.SetItemData( Index, PortfolioID );

		PortfolioStockSet.PNGetField( "PurchaseDate", Date );
		m_List.SetItemText( Index, 1, Date.Format("%m/%d/%Y %I:%M:%S %p") );

		PortfolioStockSet.PNGetField( "Shares", Shares );
		Text.Format( "%d", Shares);
		m_List.SetItemText( Index, 2, Text );

		if( PortfolioStockSet.PNGetField( "PurchasePrice", Dbl ) )
			Text.Format( "$%.2f", Dbl );
		else
			Text = "N/A";
		m_List.SetItemText( Index, 3, Text );
			
		if( TradeSet.PNGetField( "Price", Dbl ) )
			Text.Format( "$%.2f", Dbl );
		else
			Text = "N/A";

		m_List.SetItemText( Index, 4, Text );
		

		// Move to the next portfolio record
		PortfolioStockSet->MoveNext();
	}
}

BOOL CPortfolioPage::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Initialize the columns of the Portfolio List control
	m_List.InsertColumn( 0, "Stock" );
	m_List.InsertColumn( 1, "Purchase Date" );
	m_List.InsertColumn( 2, "Qty" );
	m_List.InsertColumn( 3, "Purchase" );
	m_List.InsertColumn( 4, "Latest" );

	CRect Rect;
	m_List.GetClientRect( &Rect );
	m_List.SetColumnWidth( 0, Rect.right/8 );
	m_List.SetColumnWidth( 1, Rect.right/3 + Rect.right/11 );
	m_List.SetColumnWidth( 2, Rect.right/8 );
	m_List.SetColumnWidth( 3, Rect.right/6 );
	m_List.SetColumnWidth( 4, Rect.right/6 );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPortfolioPage::OnDelete() 
{
	int Index = m_List.GetNextItem( -1, LVNI_SELECTED );
	if( Index <0 )
		MessageBox( "Please select a Stock to be deleted first" );
	else
	{
		if( MessageBox( "Are you sure you want to delete the selected Stock?", "Confirmation", MB_ICONQUESTION|MB_YESNO ) != IDYES )
			return;

		int PortfolioID = m_List.GetItemData( Index );
		
		// Delete the record using the PNExecute method of CPNADORecordset class
		// (as a SQL command)
		CString Command;
		Command.Format( "Delete from Portfolio where PortfolioID = %d", PortfolioID );
		CPNADORecordset::PNExecute( Command );

		// And finally delete it from the List View control on screen
		m_List.DeleteItem( Index );

	}
	
}

// These functions provide printing ability.  They are functions designed
// to mimick the functions that the view provides for printing, and in
// fact the view will call these functions to perform the actual print handling
BOOL CPortfolioPage::OnPreparePrinting(CPrintInfo *pInfo)
{
	if( m_List.GetItemCount() == 0 )
	{
		MessageBox( "Nothing in portfolio to print" );
		return( FALSE );
	}
	
	return( TRUE );
}

void CPortfolioPage::OnBeginPrinting(CDC *pDC, CPrintInfo *pInfo)
{
	pDC->SetMapMode( MM_HIENGLISH );

	// Create Fonts for report
	m_TitleFont.CreatePointFont( 140, "Arial", pDC );
	m_BodyFont.CreatePointFont( 90, "Arial", pDC );
	LOGFONT LogFont;
	m_BodyFont.GetLogFont( &LogFont );
	LogFont.lfWeight = FW_BOLD;
	m_HeaderFont.CreateFontIndirect( &LogFont );
	
	// Determine default margin setup
	CPageSetupDialog Tmp(PSD_RETURNDEFAULT|PSD_INTHOUSANDTHSOFINCHES);
	Tmp.DoModal();
	m_Left = Tmp.m_psd.rtMargin.left - Tmp.m_psd.rtMinMargin.left;
	m_Top = -(Tmp.m_psd.rtMargin.top - Tmp.m_psd.rtMinMargin.top);
	m_Right = Tmp.m_psd.ptPaperSize.x - Tmp.m_psd.rtMargin.right - Tmp.m_psd.rtMinMargin.left;
	m_Bottom = -(Tmp.m_psd.ptPaperSize.y - Tmp.m_psd.rtMargin.bottom - Tmp.m_psd.rtMinMargin.top);

	m_ReportTime = CTime::GetCurrentTime();

	// Save items to print in the m_lpUserData data member of pInfo
	pInfo->m_lpUserData = (void*)m_List.GetItemCount();

}


void CPortfolioPage::OnPrepareDC(CDC *pDC, CPrintInfo *pInfo)
{
	// Determine Lines per page
	CSize TextSize;
	CFont* pOldFont = pDC->SelectObject( &m_BodyFont );
	TextSize = pDC->GetTextExtent( "Hy" );
	int LineHeight = TextSize.cy;
	m_MaxLines = -((m_Bottom-m_Top) / LineHeight);
	m_MaxLines--;

	if( (pInfo->m_nCurPage-1) * m_MaxLines >= (unsigned)m_List.GetItemCount() )
		pInfo->m_bContinuePrinting = FALSE;
	else
		pInfo->m_bContinuePrinting = TRUE;

	pDC->SelectObject( pOldFont );

}

void CPortfolioPage::OnPrint(CDC *pDC, CPrintInfo *pInfo)
{
	int CurY=m_Top;
	CSize TextSize;
	CString Text;
	CFont* pOldFont;
	int CurIndex, Index=0, LineHeight;


	// Determine what item from TradeList is at top of this page
	CurIndex = (pInfo->m_nCurPage-1) * m_MaxLines;

	// Output the header
	pDC->SetMapMode( MM_HIENGLISH );
	
	// Print page header
	pDC->MoveTo( m_Left, CurY );
	pDC->LineTo( m_Right, CurY );

	pDC->SelectObject( &m_BodyFont );
	Text = m_ReportTime.Format( "%A, %B %d, %Y  %I:%M %p" );
	TextSize = pDC->GetTextExtent( Text );
	LineHeight = TextSize.cy;
	CurY += TextSize.cy+50;
	pDC->TextOut( m_Left, CurY, Text );

	Text.Format( "Page %d", pInfo->m_nCurPage );
	TextSize = pDC->GetTextExtent( Text );
	pDC->TextOut( m_Right-TextSize.cx, CurY, Text );
	
	
	Text= "Portfolio Report";
	pDC->SelectObject( &m_TitleFont );
	TextSize = pDC->GetTextExtent( Text );
	CurY += TextSize.cy+50;
	pDC->TextOut( m_Left, CurY, Text );

	pOldFont = pDC->SelectObject( &m_BodyFont );
	CurY = m_Top - 50;

	// Print column headers
	pDC->SelectObject( &m_HeaderFont );
	pDC->TextOut( m_Left, CurY, "Stock" );
	pDC->TextOut( m_Left+1000, CurY, "Purchase Date" );
	pDC->TextOut( m_Left+3000, CurY, "Qty" );
	pDC->TextOut( m_Left+4000, CurY, "Purchase" );
	pDC->TextOut( m_Left+5000, CurY, "Latest" );

	pDC->SelectObject( &m_BodyFont );
	CurY -= LineHeight;

	// Output the rows of data
	for( Index=0; Index < m_MaxLines; Index++ )
	{

		if( Index + CurIndex >= m_List.GetItemCount() )
			break;

		// Print Column 1: Stock
		Text = m_List.GetItemText( CurIndex+Index, 0 );
		pDC->TextOut( m_Left, CurY, Text );

		// Print Column 2: Purchase Date
		Text = m_List.GetItemText( CurIndex+Index, 1 );
		pDC->TextOut( m_Left+1000, CurY, Text );

		// Print Column 3: Qty
		Text = m_List.GetItemText( CurIndex+Index, 2 );
		pDC->TextOut( m_Left+3000, CurY, Text );

		// Print Column 4: Purchase
		Text = m_List.GetItemText( CurIndex+Index, 3 );
		pDC->TextOut( m_Left+4000, CurY, Text );

		// Print Column 5: Latest
		Text = m_List.GetItemText( CurIndex+Index, 3 );
		pDC->TextOut( m_Left+5000, CurY, Text );

		CurY -= LineHeight;
	}


	pDC->SelectObject( pOldFont );

}

void CPortfolioPage::OnEndPrinting(CDC *pDC, CPrintInfo *pInfo)
{
	m_TitleFont.DeleteObject();
	m_BodyFont.DeleteObject();
	m_HeaderFont.DeleteObject();
}
