#include "stdafx.h"
#include <commdlg.h>
#include "nopepad.h"

BOOL PNGetSaveFileName( HWND hWnd, char* Dest, int DestSize )
{
	OPENFILENAME Tmp;
	memset( &Tmp, 0, sizeof( Tmp ) );
	Tmp.lStructSize = sizeof( Tmp );
	Tmp.hwndOwner = hWnd;
    Tmp.lpstrFilter = "Text Files\0*.txt\0All Files\0*.*\0";
    Tmp.nFilterIndex = 1;
    Tmp.lpstrFile = Dest;
    Tmp.nMaxFile = DestSize;
    Tmp.lpstrTitle = "Save as";
    return( GetSaveFileName( &Tmp ) );
}

BOOL PNGetOpenFileName( HWND hWnd, char* Dest, int DestSize )
{
	OPENFILENAME Tmp;
	memset( &Tmp, 0, sizeof( Tmp ) );
	Tmp.lStructSize = sizeof( Tmp );
	Tmp.hwndOwner = hWnd;
    Tmp.lpstrFilter = "Text Files\0*.txt\0All Files\0*.*\0";
    Tmp.nFilterIndex = 1;
    Tmp.lpstrFile = Dest;
    Tmp.nMaxFile = DestSize;
    return( GetOpenFileName( &Tmp ) );
}

BOOL PNChooseFont( HWND hWnd, HFONT* DestFont )
{
	CHOOSEFONT Tmp;
	LOGFONT LogFont;
	HFONT CurFont = *DestFont;
	char StyleStr[32]="";

	memset( &Tmp, 0, sizeof(Tmp) );
	Tmp.lStructSize = sizeof( CHOOSEFONT );
	Tmp.hwndOwner = hWnd;
	Tmp.hDC = GetDC( hWnd );
	SetMapMode( Tmp.hDC, MM_TWIPS );
	if( *DestFont == 0 )
		CurFont = (HFONT)GetCurrentObject( Tmp.hDC, OBJ_FONT );
	else
		CurFont = *DestFont;
	GetObject( CurFont, sizeof(LOGFONT), (void*) &LogFont );
	if( LogFont.lfWeight == FW_BOLD && LogFont.lfItalic != FALSE )
		strcpy( StyleStr, "Bold Italic" );
	else if( LogFont.lfItalic )
		strcpy( StyleStr, "Italic" );
	else if( LogFont.lfWeight == FW_BOLD )
		strcpy( StyleStr, "Bold" );
	else
		strcpy( StyleStr, "Regular" );

	Tmp.iPointSize =  LogFont.lfHeight * 10;
	Tmp.Flags = CF_BOTH | CF_USESTYLE | CF_INITTOLOGFONTSTRUCT;
	Tmp.lpszStyle = StyleStr;
	Tmp.lpLogFont = &LogFont;

	if( ChooseFont( &Tmp ) != FALSE )
	{
		if( *DestFont )
			DeleteObject( *DestFont );
		*DestFont = CreateFontIndirect( &LogFont );
		return(TRUE);
	}
	return(FALSE);
}

// PNPageSetup - Invokes the Page setup dialog
// Parameters:
//     hWnd - Window handle to the parent or main window
//     PageSetup - Pointer to the PAGESETUPDLG struct to initialize
// Returns: TRUE if user hit OK, FALSE if not.
BOOL PNPageSetup(HWND hWnd, PAGESETUPDLG* PageSetup)
{
	PageSetup->lStructSize = sizeof(PAGESETUPDLG);
	PageSetup->hwndOwner = hWnd;
	if( PageSetup->rtMargin.left > 0 ) // Is there any left margin?
		PageSetup->Flags |= PSD_MARGINS; // If so, use it as initialization
    return( PageSetupDlg( PageSetup ) );
}

void PNPageSetupInit( PAGESETUPDLG* PageSetup )
{
	memset( PageSetup, 0, sizeof(PAGESETUPDLG) );
	PageSetup->lStructSize = sizeof(PAGESETUPDLG);
	PageSetup->Flags=PSD_RETURNDEFAULT | PSD_INTHOUSANDTHSOFINCHES;
	PageSetupDlg( PageSetup );
	
}

// PNGetPrinterDC - Returns a Device Context for the currently-selected printer
// Returns: The desired HDC handle for the printer, or NULL upon failure.
HDC PNGetPrinterDC()
{
	PRINTDLG Print;

	// Initialize the Print structure with zeros, and the size of the struct
	memset( &Print, 0, sizeof(Print) );
	Print.lStructSize = sizeof(PRINTDLG);
	// Indicate that we don't want to invoke the printer dialog, but want to
	// simply return the default printer DC, by setting flags:
	Print.Flags = PD_RETURNDC | PD_RETURNDEFAULT;
	// Invoke the PrintDlg function
	PrintDlg( &Print );
	return( Print.hDC );
}

void PNEzMargins( PAGESETUPDLG* PageSetup, int* Left, int *Top, int* Right, int* Bottom )
{
	*Left = PageSetup->rtMargin.left - PageSetup->rtMinMargin.left;
	*Top = -(PageSetup->rtMargin.top - PageSetup->rtMinMargin.top);
	*Right = PageSetup->ptPaperSize.x - PageSetup->rtMargin.right - PageSetup->rtMinMargin.left;
	*Bottom = -(PageSetup->ptPaperSize.y - PageSetup->rtMargin.bottom - PageSetup->rtMinMargin.top);
}


HFONT PNCreatePrinterFont( HWND hWnd, HFONT CurFont )
{
	HFONT NewFont;
	LOGFONT LogFont;

	GetObject( CurFont, sizeof(LOGFONT), &LogFont );
	
	HDC TmpDC = GetDC( hWnd );
	// Get current height divided by LOGPIXELSY, gives us logical height in inches.  Mul that by 1000
	// Becuase printer DC mode is MM_HIENGLISH where each unist it 1/1000 an inch
	LogFont.lfHeight = int( (LogFont.lfHeight / (float)GetDeviceCaps( TmpDC, LOGPIXELSY ))*1000 );
	NewFont = CreateFontIndirect( &LogFont );
	ReleaseDC( hWnd, TmpDC );
	return( NewFont );
}

