// ProgressDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MFC_CmnControl.h"
#include "PNProgressDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPNProgressDlg dialog


CPNProgressDlg::CPNProgressDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPNProgressDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPNProgressDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	// Here, we create our Dialog window (it's not visible yet though)
	Create( IDD, pParent );

	// And disable the parent window
	pParent->EnableWindow( FALSE );

	// Start Progress control off at zero
	m_Prog.SetPos( 0 );

	// And set the m_bCancel data member to false
	m_bCancel = false;
}

CPNProgressDlg::~CPNProgressDlg()
{
	GetParent()->EnableWindow( TRUE );
}

void CPNProgressDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPNProgressDlg)
	DDX_Control(pDX, IDC_DLGPROGRESS, m_Prog);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPNProgressDlg, CDialog)
	//{{AFX_MSG_MAP(CPNProgressDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPNProgressDlg message handlers

bool CPNProgressDlg::SetPos(int Pos, LPCSTR Label)
{
	MSG Msg;

	// If Window is hidden, then show it
	if( ! IsWindowVisible() )
		ShowWindow( SW_NORMAL );

	// Message Pump, to permit messages to be processed, like the Cancel button click
	while( ::PeekMessage( &Msg, 0, 0, 0, PM_NOREMOVE ) )
		AfxGetApp()->PumpMessage();

	// If not cancelled yet, then set the position
	if( !m_bCancel )
	{
		m_Prog.SetPos( Pos );
		if( Label )
			SetDlgItemText( IDC_LABEL, Label );
	}

	return( !m_bCancel );
}

void CPNProgressDlg::OnCancel() 
{
	
	if( MessageBox( "Are you sure you want to cancel?", "Confirmation", MB_ICONQUESTION|MB_YESNO ) == IDYES )
		m_bCancel = true;
	
	// Don't call OnCancel, which would close the window (ClassWizard added it)
	// CDialog::OnCancel();
}

bool CPNProgressDlg::WasCancelled()
{
	return( m_bCancel );
}


void CPNProgressDlg::Reset( int Min, int Max )
{
	m_bCancel = false;
	m_Prog.SetRange( Min, Max );
	m_Prog.SetPos( Min );
	ShowWindow( SW_NORMAL );
}
