#if !defined(AFX_TREEFOLDER_H__F52456D4_9D3F_11D3_9EDB_080009EE62AA__INCLUDED_)
#define AFX_TREEFOLDER_H__F52456D4_9D3F_11D3_9EDB_080009EE62AA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TreeFolder.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CPNDirTree window
#include <afxtempl.h>

class CPNDirTree : public CTreeCtrl
{
// Construction
public:
	CPNDirTree();
	virtual ~CPNDirTree();

// Attributes
public:
	bool m_ShowFiles;
	bool m_AutoRefresh;
	bool m_HasCheck;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPNDirTree)
	protected:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	void SetCheckStyle( bool Mode );
	void Reset();
	bool SetShowFiles( bool NewMode );
	BOOL IsFileFolder( const char* Path );
	BOOL IsFileFolder( HTREEITEM hItem=0 );
	void RefreshItem( HTREEITEM hNode );
	void CheckAll( BOOL Checked, HTREEITEM hNode=0 );
	int GetAllChecked( CStringArray& Dest );
	int GetAllChecked( CListBox& List );
	int BuildFileList( CStringArray& Dest, const char* Path, bool FullPath=true );

	void ExpandAll(HTREEITEM hNode );

	LPCSTR GetFullPath( HTREEITEM hNode );
	LPCSTR GetSubPath( const char* Str );
	
	// Generated message map functions
	void StartPath( const char* Start );
protected:
	void LoadDriveLetters(const char* OneDrive = 0 );
	int BuildFileListEx( CStringArray& Dest, const char* Path, bool FullPath=true );
	BOOL HasSubItem(const char *Folder );
	HTREEITEM AddPath(const char *Path, HTREEITEM hNode=TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST );
	void ExpandItem( HTREEITEM hNode, bool ExpandIt, bool Recursive = false );
	void LoadPath( HTREEITEM hNode, const char* Str );
	void CheckSearch( CStringArray& Dest, HTREEITEM hNode );
	void SlashPath( CString& Dest, bool MustHave );
	//{{AFX_MSG(CPNDirTree)
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

	CString m_StartPath;
	static CImageList m_ImageList;
	static int m_ObjCount;

	CList<HTREEITEM,HTREEITEM> m_Expanded;

};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TREEFOLDER_H__F52456D4_9D3F_11D3_9EDB_080009EE62AA__INCLUDED_)
