// SDK_Controls.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"
#include "PNControls.h"

LRESULT CALLBACK DialogProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam  )
{
	int wID;
	int wNotification;
	HWND hChild;

	char Path[MAX_PATH] = "C:\\*.*";

	switch( uMsg )
	{
		case WM_INITDIALOG:
			// Call Helper function to create button at runtime
			hChild = PNCreateButton( hwndDlg, "&Remove Me", 24, 24, 100, 24, 4000, 0 );

			// Set Icon for a push button 
			PNSetButtonImage( hwndDlg, IDC_IMGBUTTON, IDI_BTNICON);
			
			// Set Icons for the radio buttons
			PNSetButtonImage( hwndDlg, IDC_RADIOHORRORD, IDI_ICONHORROR );
			PNSetButtonImage( hwndDlg, IDC_RADIOHORRORC, IDI_ICONHORROR );
			PNSetButtonImage( hwndDlg, IDC_RADIOCOMEDYD, IDI_ICONCOMEDY );
			PNSetButtonImage( hwndDlg, IDC_RADIOCOMEDYC, IDI_ICONCOMEDY );
			PNSetButtonImage( hwndDlg, IDC_RADIODRAMAD, IDI_ICONDRAMA );
			PNSetButtonImage( hwndDlg, IDC_RADIODRAMAC, IDI_ICONDRAMA );
			
			// Set images for our Image with Text button:
			PNImageButtonSetData( hwndDlg, TRUE, IDC_BUTTONIMG2, IDB_CHECKUP, 0, 0, 0 );
			// Alternative example with all 4 bitmaps:
			//PNImageButtonSetData( hwndDlg, TRUE, IDC_BUTTONIMG2, IDB_CHECKUP, IDB_CHECKDOWN, IDB_CHECKFOCUS, IDB_CHECKDISABLED );


			// Create buttons dynamically, at runtime.
			PNCreateRadioButton( hwndDlg, "Horror", 375, 145, 100, 20, 4001, WS_GROUP );
			PNCreateRadioButton( hwndDlg, "Comedy", 375, 165, 100, 20, 4002, 0 );
			PNCreateRadioButton( hwndDlg, "Drama",  375, 185, 100, 20, 4003, 0 );

			// Set the initial checked item for our groups of radio buttons
			CheckRadioButton( hwndDlg, IDC_RADIOHORRORA, IDC_RADIODRAMAA, IDC_RADIOHORRORA );
			CheckRadioButton( hwndDlg, IDC_RADIOHORRORB, IDC_RADIODRAMAB, IDC_RADIOHORRORB );
			CheckRadioButton( hwndDlg, IDC_RADIOHORRORC, IDC_RADIODRAMAC, IDC_RADIOHORRORC );
			CheckRadioButton( hwndDlg, IDC_RADIOHORRORD, IDC_RADIODRAMAD, IDC_RADIOHORRORD );
			CheckRadioButton( hwndDlg, IDC_RADIOHORRORE, IDC_RADIODRAMAE, IDC_RADIOHORRORE );
			CheckRadioButton( hwndDlg, 4001,             4003,            4001 );
			
			// Limit the text length for the edit box
			SendDlgItemMessage( hwndDlg, IDC_EDITNAME, EM_LIMITTEXT, 32, 0 );

			// Dynamically create a ComboBox
			hChild = PNCreateComboBox( hwndDlg, 188, 340, 106, 3, 4004, CBS_DROPDOWNLIST );			
			SendMessage( hChild, CB_ADDSTRING, 0, (LPARAM)"Line1");
			SendMessage( hChild, CB_ADDSTRING, 0, (LPARAM)"Line2");
			SendMessage( hChild, CB_ADDSTRING, 0, (LPARAM)"Line3");
			SendMessage( hChild, CB_ADDSTRING, 0, (LPARAM)"Line4");
			// Two Methods to populate combo box with list of files:
			//SendDlgItemMessage( hwndDlg, IDC_COMBOFILES, CB_DIR, DDL_READWRITE, (LPARAM)"C:\\*.*" );
			// or:
			DlgDirListComboBox( hwndDlg, Path, IDC_COMBOFILES, 0, DDL_READWRITE );

			// List Boxes
			hChild = PNCreateListBox( hwndDlg, NULL, 19, 315, 142, 80, 4005, LBS_SORT|LBS_EXTENDEDSEL );
			SendMessage( hChild, LB_ADDSTRING, 0, (LPARAM)"Dynamic Line1" );
			SendMessage( hChild, LB_ADDSTRING, 0, (LPARAM)"Dynamic Line2" );
			SendMessage( hChild, LB_ADDSTRING, 0, (LPARAM)"Dynamic Line3" );

			SendDlgItemMessage( hwndDlg, IDC_LIST1, LB_ADDSTRING, 0, (LPARAM)"Line1" );
			SendDlgItemMessage( hwndDlg, IDC_LIST1, LB_ADDSTRING, 0, (LPARAM)"Line2" );
			SendDlgItemMessage( hwndDlg, IDC_LIST1, LB_ADDSTRING, 0, (LPARAM)"Line3" );
			// Two example of populateing list with filenames:
			// Method 1:
			//    SendDlgItemMessage( hwndDlg, IDC_LIST1, LB_RESETCONTENT, 0, 0 );
			//    SendDlgItemMessage( hwndDlg, IDC_LIST1, LB_DIR, 0, (LPARAM)Path );
			// Method 2:
			//    DlgDirList( hwndDlg, Path, IDC_LIST1, 0, DDL_READWRITE );

			// Check boxes
			PNCreateCheckBox( hwndDlg, "Dynamic", 411, 275, 75, 24, 4006, BST_CHECKED, 0 );
			// Note: Default for checkboxes is already unchecked
			CheckDlgButton( hwndDlg, IDC_CHECKPUSHLIKE, BST_UNCHECKED );
			CheckDlgButton( hwndDlg, IDC_CHECKFLAT, BST_UNCHECKED );
			CheckDlgButton( hwndDlg, IDC_CHECKICON, BST_UNCHECKED );
			CheckDlgButton( hwndDlg, IDC_CHECKTRISTATE, BST_UNCHECKED );


			// Start button for Edit demonstration in disabled mode
			PNCreateEditBox( hwndDlg, "Dynamic", 290, 80, 75, 24, 4007, 0 );
			EnableWindow( GetDlgItem(hwndDlg, IDC_BUTTONNAME), FALSE );

			// STATIC controls
			PNSetFont( hwndDlg, IDC_STATICSOMETEXT, "Times New Roman", 18, TRUE, TRUE, FALSE );

			// Initialize the comb box controls with their 'Data' properties
			PNDlgInit( hwndDlg, IDD_DIALOG1 );
			return( TRUE );

			
		case WM_DESTROY:
			
			// Relase our font selections
			PNClearFont( hwndDlg, IDC_STATICSOMETEXT );

			// Release the image we loaded for button
			PNClearButtonImage( hwndDlg, IDC_IMGBUTTON );

			// Release bitmaps for our Image with Text button
			PNImageButtonClearData( hwndDlg, IDC_BUTTONIMG2 );

			// And our Radio Buttons
			PNClearButtonImage( hwndDlg, IDC_RADIOHORRORC );
			PNClearButtonImage( hwndDlg, IDC_RADIOCOMEDYC );
			PNClearButtonImage( hwndDlg, IDC_RADIODRAMAC );
			PNClearButtonImage( hwndDlg, IDC_RADIOHORRORD );
			PNClearButtonImage( hwndDlg, IDC_RADIOCOMEDYD );
			PNClearButtonImage( hwndDlg, IDC_RADIODRAMAD );

			// Delete our dynamically-created controls
			hChild = GetDlgItem( hwndDlg, 4000 );
			if( hChild )
				DestroyWindow( hChild );

			// Destroy dynamically-created Radio buttons
			DestroyWindow( GetDlgItem( hwndDlg, 4001 ) );
			DestroyWindow( GetDlgItem( hwndDlg, 4002 ) );
			DestroyWindow( GetDlgItem( hwndDlg, 4003 ) );

			// Destroy dynamically-created combo-box
			DestroyWindow( GetDlgItem( hwndDlg, 4004 ) );

			// Destroy dynamically-created list box
			DestroyWindow( GetDlgItem( hwndDlg, 4005 ) );

			// Destroy dynamically-created check box
			DestroyWindow( GetDlgItem( hwndDlg, 4006 ) );

			// Destroy dynamically-created edit box
			DestroyWindow( GetDlgItem( hwndDlg, 4007 ) );

			break;
		case WM_DRAWITEM:
			if( wParam == IDC_BUTTONIMG2 ) // Our owner draw button
			{
				PNImageButtonDrawItem( hwndDlg, wParam, (LPDRAWITEMSTRUCT)lParam);
					return( 0 );
			}
			break;

		case WM_CLOSE:
			EndDialog( hwndDlg, 0 ); // Close the dialog
			break;

		case WM_COMMAND: // A message from a control or menu item
			// Parse out WM_COMMAND parameters to be more readable
			wID = LOWORD(wParam);
			wNotification = HIWORD(wParam);
			hChild = (HWND) lParam;

			// Our List boxes:
			if( wID == IDC_STATICSOMETEXT && wNotification == STN_CLICKED )
			{
				MessageBox( hwndDlg, "You clicked the static control", "Information", MB_OK );
			}

			// Our Listboxes
			else if( wID == IDC_LIST1 && wNotification == LBN_SELCHANGE )
			{
				int Selection = SendMessage( hChild, LB_GETCURSEL, 0, 0 );
				if( Selection != LB_ERR )
				{
					char Text[128];
					SendMessage( hChild, LB_GETTEXT, Selection, (LPARAM)Text );
					MessageBox( hwndDlg, Text, "You selected", MB_OK );
				}
			}

			// Our Comboboxes
			else if( wID == IDC_COMBOCOLOR && wNotification == CBN_SELCHANGE )
			{
				DlgDirSelectComboBoxEx( hwndDlg, Path, sizeof(Path), IDC_COMBOFILES );
				MessageBox( hwndDlg, Path, "File", MB_OK );

				char Text[64];
				int i = SendMessage( hChild, CB_GETCURSEL, 0, 0 );
				if( i != CB_ERR )
				{
					SendMessage( hChild, CB_GETLBTEXT, i, (LPARAM)Text );
					MessageBox( hwndDlg, Text, "Your selection", MB_OK );
					return(0);
				}
			}

			else if( wID == IDC_COMBOEDIT && wNotification == CBN_EDITCHANGE )
			{
				char Text[64];
				GetWindowText( hChild, Text, sizeof(Text) );
				SetDlgItemText( hwndDlg, IDC_CBTEXT, Text );
			}
			else if( wID == IDC_COMBOEDIT && wNotification == CBN_SELCHANGE)
			{
				char Text[64];
				int i = SendMessage( hChild, CB_GETCURSEL, 0, 0 );
				if( i != CB_ERR )
				{
					SendMessage( hChild, CB_GETLBTEXT, i, (LPARAM)Text );
					SetDlgItemText( hwndDlg, IDC_CBTEXT, Text );
				}
			}
			
			// Check Boxes
			else if( (wID == IDC_CHECKPUSHLIKE ) && (wNotification == BN_CLICKED) )
			{
				hChild = GetDlgItem( hwndDlg, IDC_CHECKSAMPLE );
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKPUSHLIKE ) )
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) | BS_PUSHLIKE );
				else
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) &(~BS_PUSHLIKE) );
				InvalidateRect( hChild, 0, FALSE );
			}

			else if( (wID == IDC_CHECKFLAT ) && (wNotification == BN_CLICKED) )
			{
				hChild = GetDlgItem( hwndDlg, IDC_CHECKSAMPLE );
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKFLAT ) )
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) | BS_FLAT );
				else
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) &(~BS_FLAT) );
				InvalidateRect( hChild, 0, FALSE );
			}
			else if( (wID == IDC_CHECKICON ) && (wNotification == BN_CLICKED) )
			{
				hChild = GetDlgItem( hwndDlg, IDC_CHECKSAMPLE );
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKICON ) )
				{
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) | BS_ICON );
					PNSetButtonImage( hwndDlg, IDC_CHECKSAMPLE, IDI_ICONCOMEDY );

				}
				else
				{
					SetWindowLong( hChild, GWL_STYLE, GetWindowLong( hChild, GWL_STYLE ) &(~BS_ICON) );
					PNClearButtonImage( hwndDlg, IDC_CHECKSAMPLE );
				}
				InvalidateRect( hChild, 0, FALSE );
			}			

			else if( (wID == IDC_CHECKTRISTATE ) && (wNotification == BN_CLICKED) )
			{
				hChild = GetDlgItem( hwndDlg, IDC_CHECKSAMPLE );
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKTRISTATE ) )
					SetWindowLong( hChild, GWL_STYLE, (GetWindowLong( hChild, GWL_STYLE ) & (~BS_AUTOCHECKBOX)) |BS_AUTO3STATE );
				else
					SetWindowLong( hChild, GWL_STYLE, (GetWindowLong( hChild, GWL_STYLE ) & (~BS_AUTO3STATE)) |BS_AUTOCHECKBOX );
				InvalidateRect( hChild, 0, FALSE );
			}

			else if( (wID == IDM_EDITCUT ) )
				SendMessage( GetFocus(), WM_CUT, 0, 0 );
			else if( (wID == IDM_EDITCOPY ) )
				SendMessage( GetFocus(), WM_COPY, 0, 0 );
			else if( (wID == IDM_EDITPASTE ) )
				SendMessage( GetFocus(), WM_PASTE, 0, 0 );
			else if( (wID == IDM_EDITUNDO ) )
				SendMessage( GetFocus(), WM_UNDO, 0, 0 );

			// Our edit control text changed.  Determine to enable button or not
			else if( (wID == IDC_EDITNAME ) && wNotification == EN_CHANGE )
			{
				if( GetWindowTextLength( hChild ) > 0 )
					EnableWindow( GetDlgItem(hwndDlg, IDC_BUTTONNAME), TRUE );
				else
					EnableWindow( GetDlgItem(hwndDlg, IDC_BUTTONNAME), FALSE );

			}
			else if( (wID == IDC_CHECKPASSWORD ) && wNotification == BN_CLICKED )
			{
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKPASSWORD ) )
					SendDlgItemMessage( hwndDlg, IDC_EDITNAME, EM_SETPASSWORDCHAR, '*', 0 );
				else
					SendDlgItemMessage( hwndDlg, IDC_EDITNAME, EM_SETPASSWORDCHAR, 0, 0 );
				InvalidateRect( GetDlgItem(hwndDlg, IDC_EDITNAME), 0, 0 );
			}
			else if( (wID == IDC_CHECKREADONLY ) && wNotification == BN_CLICKED )
			{
				if( IsDlgButtonChecked( hwndDlg, IDC_CHECKREADONLY ) )
					SendDlgItemMessage( hwndDlg, IDC_EDITNAME, EM_SETREADONLY, 1, 0 );
				else
					SendDlgItemMessage( hwndDlg, IDC_EDITNAME, EM_SETREADONLY, 0, 0 );
				InvalidateRect( GetDlgItem(hwndDlg, IDC_EDITNAME), 0, 0 );
			}
			// Did user click the 'Hello' button?  If so, display their text
			else if( (wID == IDC_BUTTONNAME) && wNotification == BN_CLICKED )
			{
				char Tmp[32];
				GetDlgItemText( hwndDlg, IDC_EDITNAME, Tmp, sizeof(Tmp) );
				PNMLEditGetLine( GetDlgItem(hwndDlg, IDC_EDITMULTI), 1, Tmp, sizeof(Tmp) );
				//PNMLEditSetLine( GetDlgItem(hwndDlg, IDC_EDITMULTI), 1, "A Test" );
				MessageBox( hwndDlg, Tmp, "You entered", MB_OK );
			}
			// Did user click the 'Clear' button?  If so, clear out edit box
			else if( (wID == IDC_BUTTONNAMECLEAR) && wNotification == BN_CLICKED )
				SetDlgItemText( hwndDlg, IDC_EDITNAME, "" );

			// Was our Image button clicked? If so show a nice message
			else if( (wID == IDC_IMGBUTTON ) && wNotification == BN_CLICKED )
				MessageBox( hwndDlg, "You clicked the simple image button", "Information", MB_OK );

			else if( (wID == IDC_BUTTONIMG2) && wNotification == BN_CLICKED )
				MessageBox( hwndDlg, "You clicked the Image and Text button", "", MB_OK );

			
			// If our dynamically-created button was clicked, then we destroy it
			else if( (wID == 4000 ) && wNotification == BN_CLICKED )
				DestroyWindow( hChild );
			
			// If OK or Cancel button was clicked, then we do an EndDialog
			else if( (wID == IDOK || wID==IDCANCEL) && wNotification == BN_CLICKED )
				EndDialog( hwndDlg, wID ); // Close the dialog
			
			else if( wID == IDM_FILEEXIT ) // File/Exit menu choice
				EndDialog( hwndDlg, IDOK ); // Close the dialog

			
			break;

	}
	return( FALSE );
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	DialogBox( hInstance, MAKEINTRESOURCE(IDD_DIALOG1), 0, (DLGPROC)DialogProc );

	return 0;
}



