
struct PNImageButtonInfo {
	// Bitmaps for our button
	HBITMAP hImageUp, hImageDown, hImageFocus, hImageDisabled;
	// Determine if image is on left or right of the text
	BOOL bImageOnLeft; // TRUE=Left, FALSE=Right
	// Image width and height (all assumed same size)
	int nImageWidth, nImageHeight;
};


HWND PNCreateButton( HWND hParent, LPCTSTR lpCaption, int x, int y, int nWidth, int nHeight, int nID, int nStyle );
HWND PNCreateRadioButton( HWND hParent, LPCTSTR lpCaption, int x, int y, int nWidth, int nHeight, int nID, int nStyle );
HWND PNCreateComboBox( HWND hParent, int x, int y, int nWidth, int nHeight, int nID, int nStyle );
HWND PNCreateCheckBox( HWND hParent, LPCTSTR lpCaption, int x, int y, int nWidth, int nHeight, int nID, int State, int nStyle );
HWND PNCreateEditBox( HWND hParent, LPCTSTR lpCaption, int x, int y, int nWidth, int nHeight, int nID, int nStyle );
HWND PNCreateListBox( HWND hParent, LPCTSTR lpCaption, int x, int y, int nWidth, int nHeight, int nID, int nStyle );

BOOL PNSetButtonImage( HWND hParent, UINT uButtonID, UINT uImageID );
void PNClearButtonImage( HWND hParent, UINT uButtonID );

BOOL PNMLEditGetLine( HWND hChild, int Line, char* Dest, int MaxLen );
BOOL PNMLEditSetLine( HWND hChild, int Line, char* Src );

BOOL PNDlgInit( HWND hParent, int ID );

void PNDrawTransparent(HDC DC, int x, int y, HBITMAP hbmImage, BOOL LowerLeft, COLORREF crColor);
BOOL PNImageButtonDrawItem( HWND hParent, int ID, LPDRAWITEMSTRUCT lpDrawItem  );
BOOL PNImageButtonSetData( HWND hParent, int Pos, int ID, int IDUp, int IDDown, int IDFocus, int IDDisable );
BOOL PNImageButtonClearData( HWND hParent, int ID );

BOOL PNSetFont( HWND hParent, int nID, const char* lpszFontName, int nHeight, BOOL bBold, BOOL bItalic, BOOL bUnderline );
void PNClearFont( HWND hParent, int nID  );
