// MFC_ControlsView.cpp : implementation of the CMFC_ControlsView class
//

#include "stdafx.h"
#include "MFC_Controls.h"

#include "MFC_ControlsDoc.h"
#include "MFC_ControlsView.h"

#include "CPNControls.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMFC_ControlsView

IMPLEMENT_DYNCREATE(CMFC_ControlsView, CFormView)

BEGIN_MESSAGE_MAP(CMFC_ControlsView, CFormView)
	//{{AFX_MSG_MAP(CMFC_ControlsView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CHECKFLAT, OnCheckflat)
	ON_BN_CLICKED(IDC_CHECKICON, OnCheckicon)
	ON_BN_CLICKED(IDC_BUTTONIMG2, OnButtonimg2)
	ON_BN_CLICKED(IDC_BUTTONNAME, OnButtonname)
	ON_BN_CLICKED(IDC_CHECKPASSWORD, OnCheckpassword)
	ON_BN_CLICKED(IDC_CHECKREADONLY, OnCheckreadonly)
	ON_CBN_EDITCHANGE(IDC_COMBOEDIT, OnEditchangeComboedit)
	ON_CBN_SELCHANGE(IDC_COMBOEDIT, OnSelchangeComboedit)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_EN_CHANGE(IDC_EDITNAME, OnChangeEditname)
	ON_BN_CLICKED(IDC_CHECKPUSHLIKE, OnCheckpushlike)
	ON_BN_CLICKED(IDC_CHECKTRISTATE, OnChecktristate)
	ON_BN_CLICKED(IDC_BUTTONNAMECLEAR, OnButtonnameclear)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_BN_CLICKED(IDC_STATICICON, OnStaticicon)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_BN_CLICKED(4000, OnClickDynamic)
	ON_CBN_SELCHANGE(4004, OnSelchangeComboDynamic)
	ON_BN_CLICKED(4006, OnClickDynamicCheck)
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMFC_ControlsView construction/destruction

CMFC_ControlsView::CMFC_ControlsView()
	: CFormView(CMFC_ControlsView::IDD)
{
	//{{AFX_DATA_INIT(CMFC_ControlsView)
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CMFC_ControlsView::~CMFC_ControlsView()
{
}

void CMFC_ControlsView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMFC_ControlsView)
	DDX_Control(pDX, IDC_BUTTONIMG2, m_ImageWithText);
	//}}AFX_DATA_MAP
}

BOOL CMFC_ControlsView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

BOOL CPNSetFont( CWnd* pParent, int nID, const char * lpszFontName, int nHeight, BOOL bBold, BOOL bItalic, BOOL bUnderline )
{
	CFont* pCurFont, *pParentFont;
	CWnd* pChild = pParent->GetDlgItem( nID );

	// Make sure we have valid child control
	if( !pChild )
		return( FALSE );

	// Get current font from child and parent windows
	pCurFont = pChild->GetFont();
	pParentFont = pParent->GetFont();

	// If the font is not the same as the parent font or the system font, then
	// we probably created it.  Remove it.
	if( pCurFont != pParentFont && pCurFont->GetSafeHandle() != GetStockObject(SYSTEM_FONT) )
	{
		delete pCurFont;
		pChild->SetFont( pParentFont );
	}

	// Create the new font dynamically.
	CFont* pFont = new CFont;
	if( !pFont )
		return( FALSE );
	if( pFont->CreateFont( nHeight, 0, 0, 0, bBold?FW_BOLD:FW_NORMAL,
			bItalic, bUnderline, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
			CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_DONTCARE|DEFAULT_PITCH, lpszFontName ) == FALSE )
			return( FALSE );

	// Tell the child control to use that font from now on
	pChild->SetFont( pFont );
	return(TRUE);
}

void CPNClearFont( CWnd* pParent, int nID )
{
	CFont* pCurFont, *pParentFont;
	CWnd* pChild = pParent->GetDlgItem( nID );

	// Make sure we have a valid child font
	if( !pChild )
		return;

	// Get child and parent fonts
	pCurFont = pChild->GetFont();
	pParentFont = pParent->GetFont();

	// If the current font is not the parents font, and not the system font, then delete it
	if( pCurFont != pParentFont && pCurFont->GetSafeHandle() != GetStockObject(SYSTEM_FONT) )
	{
		delete pCurFont;
		// And make sure we leave the control with a valid font to use
		pChild->SetFont( pParentFont );
	}
}

void CMFC_ControlsView::OnInitialUpdate()
{

	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	static bool DoneOnce = false;

	if( !DoneOnce )
	{
		DoneOnce = true;

		// Set unique font for a control
		CPNSetFont( this, IDC_STATICSOMETEXT, "Times New Roman", 18, TRUE, TRUE, FALSE );

		// Since this is a CFormView, the font changes after the window is created in OnCreate.
		// So we need to set the font for our child window to be like the parent here, and not
		// in OnCreate.
		m_DynaButton.SetFont( GetFont() );

		// Set font for dynamically created Radio buttons, using font of parent ('this') window.
		m_DynaRadio1.SetFont( GetFont() );
		m_DynaRadio2.SetFont( GetFont() );
		m_DynaRadio3.SetFont( GetFont() );

		// Check our initial selection in our radio button groups
		CheckRadioButton( IDC_RADIOHORRORA, IDC_RADIODRAMAA, IDC_RADIOHORRORA );
		CheckRadioButton( IDC_RADIOHORRORB, IDC_RADIODRAMAB, IDC_RADIOHORRORB );
		CheckRadioButton( IDC_RADIOHORRORC, IDC_RADIODRAMAC, IDC_RADIOHORRORC );
		CheckRadioButton( IDC_RADIOHORRORD, IDC_RADIODRAMAD, IDC_RADIOHORRORD );

		// Set Images (ocons) for our readio buttons)
		CPNSetButtonImage( this, IDC_RADIOHORRORC, IDI_ICONHORROR );
		CPNSetButtonImage( this, IDC_RADIOCOMEDYC, IDI_ICONCOMEDY );
		CPNSetButtonImage( this, IDC_RADIODRAMAC, IDI_ICONDRAMA );
		CPNSetButtonImage( this, IDC_RADIOHORRORD, IDI_ICONHORROR );
		CPNSetButtonImage( this, IDC_RADIOCOMEDYD, IDI_ICONCOMEDY );
		CPNSetButtonImage( this, IDC_RADIODRAMAD, IDI_ICONDRAMA );

		// Set our dynamically create checkbox font
		m_DynaCheck.SetFont( GetFont() );

		//Set our dynamically created combo box font
		m_DynaCombo.SetFont( GetFont() );

		// Set font for our dynamically-create listbox:
		m_DynaList.SetFont( GetFont() );
		CListBox* pList = (CListBox*)GetDlgItem( IDC_LIST1 );
		pList->ResetContent();
		pList->AddString( "Line 1" );
		pList->AddString( "Line 2" );
		pList->AddString( "Line 3" );

		
		// Three different methods to get file list into a combo box:
		char Path[MAX_PATH]="C:\\*.*";
		// Method 1: DlgDirListComboBox
		DlgDirListComboBox( Path, IDC_COMBOFILES, 0, DDL_READWRITE );
		// Method 2: Messages to reset content and get file list
		SendDlgItemMessage( IDC_COMBOFILES, CB_RESETCONTENT, 0, 0 );
		SendDlgItemMessage( IDC_COMBOFILES, CB_DIR, DDL_READWRITE, (LPARAM) Path );
		// Method 3: CCombo class and ResetContent and Dir functions
		CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_COMBOFILES);
		pCombo->ResetContent();
		pCombo->Dir( DDL_READWRITE, Path );

		// Edit control setup
		m_DynaEdit.SetFont( GetFont() );
		OnChangeEditname(); // Call to disable the 'Hello' button

		CEdit* pEdit = (CEdit*)GetDlgItem( IDC_EDITNAME );
		pEdit->SetLimitText( 12 );

	}
	CPNSetButtonImage( this, IDC_IMGBUTTON, IDI_BTNICON );
	
}

/////////////////////////////////////////////////////////////////////////////
// CMFC_ControlsView printing

BOOL CMFC_ControlsView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMFC_ControlsView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMFC_ControlsView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CMFC_ControlsView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CMFC_ControlsView diagnostics

#ifdef _DEBUG
void CMFC_ControlsView::AssertValid() const
{
	CFormView::AssertValid();
}

void CMFC_ControlsView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CMFC_ControlsDoc* CMFC_ControlsView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMFC_ControlsDoc)));
	return (CMFC_ControlsDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMFC_ControlsView message handlers

int CMFC_ControlsView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFormView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

	// Initialize the m_DynaButton object, creating the window.
	// See OnInitialUpdate also
	CRect PosAndSize( 23, 28, 98, 50 );
	m_DynaButton.Create( "&Remove me", WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_PUSHBUTTON, PosAndSize, this, 4000 );


	// Dynamically create redio buttons
	PosAndSize.SetRect(375, 145, 475, 165);
	m_DynaRadio1.Create( "Horror", WS_VISIBLE|WS_CHILD|WS_GROUP|BS_AUTORADIOBUTTON,
		PosAndSize, this, 4001 );
	PosAndSize.SetRect(375, 165, 475, 185 );
	m_DynaRadio2.Create( "Comedy", WS_VISIBLE|WS_CHILD|BS_AUTORADIOBUTTON,
		PosAndSize, this, 4002);
	PosAndSize.SetRect(375, 185, 475, 205 );
	m_DynaRadio3.Create( "Drama", WS_VISIBLE|WS_CHILD|BS_AUTORADIOBUTTON,
		PosAndSize, this, 4003);

	// Image with Text button
	m_ImageWithText.SetData( TRUE, IDB_CHECKUP );

	// Dynamically create a combo box
	PosAndSize.SetRect( 190, 340, 294, 420 );
	m_DynaCombo.Create( WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL|CBS_DROPDOWNLIST, PosAndSize, this, 4004 );
	m_DynaCombo.AddString( "Line1" );
	m_DynaCombo.AddString( "Line2" );
	m_DynaCombo.AddString( "Line3");
	m_DynaCombo.AddString( "Line4" );
	
	// Dynamically create listbox
	PosAndSize.SetRect(19, 315, 161, 395);
	m_DynaList.CreateEx( WS_EX_CLIENTEDGE, "LISTBOX", NULL, 
		WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL|LBS_SORT|LBS_EXTENDEDSEL,
		PosAndSize, this, 4005 );
	m_DynaList.AddString( "Dynamic Line 1");
	m_DynaList.AddString( "Dynamic Line 2");
	m_DynaList.AddString( "Dynamic Line 3");

	// Dynamically create Checkbox
	PosAndSize.SetRect( 411, 275, 485, 299 );
	m_DynaCheck.Create( "Dynamic", WS_VISIBLE|WS_CHILD|BS_AUTOCHECKBOX, PosAndSize, this, 4006 );

	// Dynamically create edit box
	PosAndSize.SetRect( 290, 80, 365, 104 );
	m_DynaEdit.CreateEx( WS_EX_CLIENTEDGE, "EDIT", NULL, WS_VISIBLE|WS_CHILD|WS_TABSTOP,
		PosAndSize, this, 4007 );

	
	return 0;
}

void CMFC_ControlsView::OnClickDynamic() 
{
	// Destroy the dynamically-created window
	m_DynaButton.DestroyWindow();
	
}


void CMFC_ControlsView::OnDestroy() 
{
	CFormView::OnDestroy();

	CPNClearFont( this, IDC_STATICSOMETEXT );

	CPNClearButtonImage( this, IDC_RADIOHORRORC );	
}

void CMFC_ControlsView::OnCheckpushlike() 
{
	// Demonstrates use of IsDlgButtonChecked to determine check status
	CButton* pCheck = (CButton*)GetDlgItem( IDC_CHECKSAMPLE );
	if( pCheck )
	{
		if( IsDlgButtonChecked( IDC_CHECKPUSHLIKE ) )
			pCheck->ModifyStyle( 0, BS_PUSHLIKE );
		else
			pCheck->ModifyStyle( BS_PUSHLIKE, 0 );
		pCheck->InvalidateRect( 0 );
	}
	
}

void CMFC_ControlsView::OnCheckflat() 
{
	// Demonstrates use of IsDlgButtonChecked to determine check status
	CButton* pCheck = (CButton*)GetDlgItem( IDC_CHECKSAMPLE );
	if( pCheck )
	{
		if( IsDlgButtonChecked( IDC_CHECKFLAT ) )
			pCheck->ModifyStyle( 0, BS_FLAT );
		else
			pCheck->ModifyStyle( BS_FLAT, 0 );
		pCheck->InvalidateRect( 0 );
	}

}

void CMFC_ControlsView::OnCheckicon() 
{
	// Demonstrates use of GetCheck to determine check status
	CButton* pCheck = (CButton*)GetDlgItem( IDC_CHECKICON );
	CButton* pSample = (CButton*)GetDlgItem( IDC_CHECKSAMPLE );

	if( pCheck->GetCheck() == BST_CHECKED )
	{
		pSample->ModifyStyle( 0, BS_ICON );
		CPNSetButtonImage( this, IDC_CHECKSAMPLE, IDI_ICONCOMEDY );
	}
	else
	{
		CPNClearButtonImage( this, IDC_CHECKSAMPLE );
		pSample->ModifyStyle( BS_ICON, 0);
	}
	pSample->InvalidateRect( 0 );
	
}

void CMFC_ControlsView::OnChecktristate() 
{
	// Demonstrates use of IsDlgButtonChecked to determine check status
	CButton* pCheck = (CButton*)GetDlgItem( IDC_CHECKSAMPLE );
	if( pCheck )
	{
		if( IsDlgButtonChecked( IDC_CHECKTRISTATE )>0 )
			pCheck->ModifyStyle( BS_AUTOCHECKBOX, BS_AUTO3STATE );
		else
			pCheck->ModifyStyle( BS_AUTO3STATE, BS_AUTOCHECKBOX  );
		pCheck->InvalidateRect( 0 );
	}

	
}

void CMFC_ControlsView::OnClickDynamicCheck() 
{
	
	MessageBox( "You clicked the dynamic checkbox" );
	CheckDlgButton( IDC_CHECKFLAT, BST_CHECKED );

}

void CMFC_ControlsView::OnButtonimg2() 
{
	// Response to user hitting the IDC_BUTTONIMG2 button
	MessageBox( "You clicked the Image with Text button" );
	
}

void CMFC_ControlsView::OnButtonname() 
{
	// Get text from edit box, and display in a messagebox
	CString Text;
	GetDlgItemText( IDC_EDITNAME, Text );
	Text = "Hello " + Text;
	MessageBox( Text );

}

void CMFC_ControlsView::OnButtonnameclear() 
{
	// Clear out the text fromn edit box
	SetDlgItemText( IDC_EDITNAME, "" );	
}

void CMFC_ControlsView::OnCheckpassword() 
{
	// When user clicks the Password checkbox, toggle edit control
	// between normal and password mode
	CEdit* pEdit = (CEdit*)GetDlgItem( IDC_EDITNAME );
	if( IsDlgButtonChecked( IDC_CHECKPASSWORD ) )
		pEdit->SetPasswordChar( '*' );
	else
		pEdit->SetPasswordChar( 0 );
	pEdit->InvalidateRect( 0 );
}

void CMFC_ControlsView::OnCheckreadonly() 
{
	// When user clicks Readonly checkbox toggle edit control between normal
	// and read-only mode.
	CEdit* pEdit = (CEdit*)GetDlgItem( IDC_EDITNAME );
	if( IsDlgButtonChecked( IDC_CHECKREADONLY ) )
		pEdit->SetReadOnly( TRUE );
	else
		pEdit->SetReadOnly( FALSE );
}

void CMFC_ControlsView::OnSelchangeComboDynamic() 
{
	// This is a message handler for a dynamically-created combo box.
	CComboBox* pBox = (CComboBox*)GetDlgItem( 4004 );
	int Selection = pBox->GetCurSel();
	if( Selection != CB_ERR )
	{
		CString Text;
		pBox->GetLBText( Selection, Text );
		MessageBox( Text );
	}
	
}

void CMFC_ControlsView::OnEditchangeComboedit() 
{
	CString Text;

	// Get CWnd pointer for combo box, and retrieve its text
	CWnd* pWnd = GetDlgItem( IDC_COMBOEDIT );
	pWnd->GetWindowText( Text );
	
	// Get CWnd pointer for static control, and place text into it.
	pWnd = GetDlgItem(IDC_CBTEXT);
	pWnd->SetWindowText( Text );

}

void CMFC_ControlsView::OnSelchangeComboedit() 
{
	// Get CWnd pointer for combo box
	CComboBox* pCombo = (CComboBox*) GetDlgItem( IDC_COMBOEDIT );
	
	// Get its current selection, if any
	int i = pCombo->GetCurSel();
	if( i != CB_ERR )
	{
		CString Text;
		// Get the text of the selected item
		pCombo->GetLBText( i, Text );
		// And place the text into static control
		GetDlgItem(IDC_CBTEXT)->SetWindowText(Text);

	}
}


void CMFC_ControlsView::OnSelchangeList1() 
{
	// Handle the user making a sellection from a listbox
	CListBox* pList = (CListBox*)GetDlgItem( IDC_LIST1 );

	int Selection = pList->GetCurSel();
	if( Selection != LB_ERR )
	{
		CString Text;
		pList->GetText( Selection, Text );
		MessageBox( Text, "You selected", MB_OK );
	}
	
}

void CMFC_ControlsView::OnChangeEditname() 
{
	// Based on user typing into an edit box, this show how to disable or enable 
	// another control (a button) if the text is blank or not.
	CEdit* pEdit = (CEdit*)GetDlgItem( IDC_EDITNAME );
	CWnd* pButton = GetDlgItem( IDC_BUTTONNAME );
	if( pEdit->GetWindowTextLength() > 0 )
		pButton->EnableWindow( TRUE );
	else
		pButton->EnableWindow( FALSE );

}



// Menu handlers for the Cut/Copy/Paste menu items
void CMFC_ControlsView::OnEditCopy() 
{
	// Get focused window
	CEdit* pEdit = (CEdit*)GetFocus();
	
	// If found the focused window, then do the copy
	// Note: Because of the OnUpdateEditCopy function, this menu item would
	// only have been enabled if an edit box were focused.  Otherwise we would
	// check to see if pEdit really pointed to an edit box.
	if( pEdit )
		pEdit->Copy();
}


void CMFC_ControlsView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	// Get the currently focused window
	CEdit* pEdit = (CEdit*)GetFocus();
	
	if( !pEdit )
		pCmdUI->Enable( FALSE ); //Nothing focused, disable menu item
	else

	{
		// Get its class name
		char Text[32];
		::GetClassName( pEdit->m_hWnd, Text, sizeof(Text));

		// Was it an Edit box?
		if( stricmp( Text, "EDIT" ) == 0 )
		{
			// At this point, we know it's an edit box.
			// Now we see if the user has selected some text in the edit box.
			int nStart, nEnd;
			pEdit->GetSel( nStart, nEnd );

			// If they have, then the Edit/Copy menu item should be enabled
			if( nStart != nEnd )
				pCmdUI->Enable( TRUE );
			else
				pCmdUI->Enable( FALSE ); // If not, it should be disabled
		}
	}
	
}

void CMFC_ControlsView::OnEditCut() 
{
	// TODO: Add your command handler code here
	
}

void CMFC_ControlsView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void CMFC_ControlsView::OnEditPaste() 
{
	// TODO: Add your command handler code here
	
}

void CMFC_ControlsView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}


void CMFC_ControlsView::OnStaticicon() 
{
	ShellExecute( m_hWnd, NULL, "http://www.openroad.org", NULL, NULL, SW_SHOWNORMAL );
}
