// SDK_Chap4.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"

LRESULT CALLBACK DialogProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam  );

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	DialogBox( 0, MAKEINTRESOURCE(IDD_DIALOG1), 0, (DLGPROC)DialogProc );

	return 0;
}

// PN: Simplified font-creation function
HFONT SimpleCreateFont( int Height, BOOL Bold, BOOL Italic, BOOL Underline, BOOL StrikeOut, DWORD Family, char* FaceName )
{
	HFONT Ret;
	int Weight;

	Weight = Bold ? FW_BOLD : FW_NORMAL;

	Ret = CreateFont( Height, 0, 0, 0, Weight,
		Italic, Underline, StrikeOut, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | Family, FaceName );

	return( Ret );
}

LRESULT CALLBACK DialogProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam  )
{
	int wID;
	int wNotification;
	RECT ChildRect;
	int Width;
	int Height;
	HWND hChild;
	static HFONT hFont;

	switch( uMsg )
	{
		case WM_INITDIALOG:
			// Place check in the Checkbox, since Close button starts as enable
			CheckDlgButton( hwndDlg, IDC_ENABLECLOSE, BST_CHECKED );
			// Create our font, stored in static variable for persistance
			hFont = SimpleCreateFont( 15, FALSE, TRUE, FALSE, FALSE, 0, "Times New Roman" );
			// Use WM_SETFONT message to tell child control to use new font
			SendMessage( GetDlgItem( hwndDlg, IDC_ENABLECLOSE ), WM_SETFONT, (WPARAM)hFont, 0 );
			return( TRUE );
		case WM_CLOSE:
			EndDialog( hwndDlg, 0 ); // Close the dialog
			DeleteObject( hFont );
			break;
		
		case WM_COMMAND: // A message from a control or menu item
			
			// Parse out WM_COMMAND parameters to be more readable
			wID = LOWORD(wParam);
			wNotification = HIWORD(wParam);
			hChild = (HWND) lParam;
			
			// Was the 'Always On Top' checkbox clicked?
			if( wID == IDC_ONTOP && wNotification==BN_CLICKED )
			{	// If so, get current check state
				int CheckedState = SendMessage( hChild, BM_GETCHECK, 0, 0 );
				// And SetWindowPos to be top most or not
				if( CheckedState == BST_CHECKED )
					SetWindowPos( hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE );
				else
					SetWindowPos( hwndDlg, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE );
			}
			else
			// Was the Close button clicked?
			if( wID == IDC_CLOSE && wNotification == BN_CLICKED )
				EndDialog( hwndDlg, 0 ); // Close the dialog
			else
			// Was the 'Hide' checkbox clicked?
			if( wID == IDC_HIDEBUTTON && wNotification==BN_CLICKED )
			{	// If so, get current check state
				int CheckedState = SendMessage( hChild, BM_GETCHECK, 0, 0 );
				// And either hide or show the Close button
				if( CheckedState == BST_CHECKED )
					ShowWindow( GetDlgItem( hwndDlg, IDC_CLOSE ), SW_HIDE );
				else
					ShowWindow( GetDlgItem( hwndDlg, IDC_CLOSE ), SW_SHOW );
			}
			else if( wID == IDC_ENABLECLOSE && wNotification==BN_CLICKED )
			{	// If so, get current check state
				int CheckedState = IsDlgButtonChecked( hwndDlg, IDC_ENABLECLOSE );
				// And either Enable or Disable the Close button
				hChild = GetDlgItem( hwndDlg, IDC_CLOSE );
				if( CheckedState == BST_CHECKED )
					EnableWindow( hChild, TRUE );
				else
					EnableWindow( hChild, FALSE );
			}
			else if( wID == IDC_REQUIRED && wNotification == EN_KILLFOCUS )
			{
				// If the edit box lost focus, lets see if it's empty
				if( GetWindowTextLength( hChild ) == 0 )
				{
					// If it is, then display error, and set focus back to the control
					MessageBox( NULL, "Please enter some text", "Field can not be blank", MB_OK );
					SetFocus( hChild );
				}
			}
				
			break;

		case WM_SIZE:
				// Determine new window size
				Width = LOWORD(lParam);
				Height = HIWORD(lParam);
				// Get handle to the 'status' STATIC control
				hChild = GetDlgItem( hwndDlg, IDC_STATUS );
				// And Move and size it, based on new height and width
				MoveWindow( hChild, 0, Height-18, Width, 18, TRUE );
				// Now, get the handle to the Close button
				hChild = GetDlgItem( hwndDlg, IDC_CLOSE );
				// Get the buttons dimensions, so we can right-justify the control
				GetClientRect( hChild, &ChildRect );
				// And, position it
				SetWindowPos( hChild, NULL, Width - ChildRect.right, 
					Height - 20 - ChildRect.bottom, 0, 0, 
					SWP_NOZORDER|SWP_NOSIZE);
				// Note: The hWndInsertAfter, cx, and cy parameters are NULL and 0,
				// and the uFlags parameter is a combination of SWP_NOZORDER and
				// SWP_NOSIZE.

			break;

	}
	return( FALSE );
}


