// dlgdata_sdk.cpp : Defines the entry point for the application.
//


#include "stdafx.h"
#include "resource.h"
#include <stdlib.h> // For atoi

// The person class, what we will be editing
class Person
{
public:
	void BuildString( char* Dest )
	{
		wsprintf( Dest, "%s is %d years old, and %s eligible", 
			Name, Age, Eligible?"is":"is not" );
	}
	char Name[31];
	int Age;
	bool Eligible;
};

// Window procedure for the person edit dialog.
BOOL CALLBACK EditDlgProc(  HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static Person* pPerson;
	char Buffer[256];

	switch( uMsg )
	{
	case WM_INITDIALOG:
		// Save address of the person we will be editing, and setup our edit controls
		// for user editing, with data from the person object.
		pPerson = (Person*)lParam;
		SendDlgItemMessage( hwndDlg, IDC_NAME, EM_LIMITTEXT, sizeof(pPerson->Name)-1, 0 );
		SetDlgItemText( hwndDlg, IDC_NAME, pPerson->Name );
		wsprintf( Buffer, "%d", pPerson->Age );
		SetDlgItemText( hwndDlg, IDC_AGE, Buffer );
		SendDlgItemMessage( hwndDlg, IDC_ELIGIBLE, BM_SETCHECK, pPerson->Eligible, 0 );
		return( FALSE );
	case WM_COMMAND:
		if( LOWORD(wParam) == IDOK )
		{
			// User hit Ok, save their edits back to the person structure, and close dialog
			GetDlgItemText( hwndDlg, IDC_NAME, pPerson->Name, sizeof(pPerson->Name) );
			GetDlgItemText( hwndDlg, IDC_AGE, Buffer, sizeof(Buffer) );
			pPerson->Age = atoi( Buffer );
			pPerson->Eligible = SendDlgItemMessage( hwndDlg, IDC_ELIGIBLE, BM_GETCHECK, 0, 0 )?true:false;
			EndDialog( hwndDlg, IDOK );
			return( TRUE );
		}
		else if (LOWORD(wParam) == IDCANCEL )
		{
			// User hit Cancel, close dialog without saving user edits
			EndDialog( hwndDlg, IDCANCEL );
			return( TRUE );
		}
	}
	return( FALSE );
}


// The main dialog, displays person information, and invokes the edit dialog.
BOOL CALLBACK DialogProc(  HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static Person* pPerson;
	char Buffer[256];

	switch( uMsg )
	{
	case WM_INITDIALOG:
		// Initialize dialog by saving pointer to person object we will be changing,
		// and initializing child controls (the static control)
		pPerson = (Person*)lParam;
		pPerson->BuildString( Buffer );
		SetDlgItemText( hwndDlg, IDC_DATA, Buffer );
		return( FALSE );
	case WM_COMMAND:
		if( LOWORD(wParam) == IDC_EDIT )
		{
			// User hit the edit button, invoke the edit dialog.
			if( DialogBoxParam( 0, MAKEINTRESOURCE(IDD_EDIT), hwndDlg, (DLGPROC)EditDlgProc, (LPARAM)pPerson ) == IDOK )
			{
				// If user hit ok, then get user's changes and put into the static control
				pPerson->BuildString( Buffer );
				SetDlgItemText( hwndDlg, IDC_DATA, Buffer );
			}
			return( TRUE );
		}
		else if (LOWORD(wParam) == IDC_CLOSE )
		{
			EndDialog( hwndDlg, IDC_CLOSE );
			return( TRUE );
		}
	}
	return( FALSE );
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	// Create and initialize the person object we will be working with.
	Person P;
	strcpy( P.Name, "Bob" );
	P.Age = 21;
	P.Eligible = true;

	// Invoke the main dialog.
	DialogBoxParam( hInstance, MAKEINTRESOURCE(IDD_MAINFORM), 0, (DLGPROC)DialogProc, (LPARAM)&P );
	return 0;
}





