// Menu_MFCView.cpp : implementation of the CMenu_MFCView class
//

#include "stdafx.h"
#include "Menu_MFC.h"

#include "Menu_MFCDoc.h"
#include "Menu_MFCView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView

IMPLEMENT_DYNCREATE(CMenu_MFCView, CView)

BEGIN_MESSAGE_MAP(CMenu_MFCView, CView)
	//{{AFX_MSG_MAP(CMenu_MFCView)
	ON_COMMAND(IDM_ROUNDED, OnRounded)
	ON_COMMAND(IDM_RECTANGLE, OnRectangle)
	ON_COMMAND(IDM_CIRCLE, OnCircle)
	ON_UPDATE_COMMAND_UI(IDM_CIRCLE, OnUpdateCircle)
	ON_UPDATE_COMMAND_UI(IDM_RECTANGLE, OnUpdateRectangle)
	ON_UPDATE_COMMAND_UI(IDM_ROUNDED, OnUpdateRounded)
	ON_COMMAND(IDM_ADD, OnAdd)
	ON_COMMAND(IDM_EDIT, OnEdit)
	ON_COMMAND(IDM_DELETE, OnDelete)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView construction/destruction

CMenu_MFCView::CMenu_MFCView()
{
	// TODO: add construction code here
	CurrentShape = IDM_RECTANGLE;
	IsRounded = FALSE;

}

CMenu_MFCView::~CMenu_MFCView()
{
}

BOOL CMenu_MFCView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}


/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView printing

BOOL CMenu_MFCView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMenu_MFCView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMenu_MFCView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView diagnostics

#ifdef _DEBUG
void CMenu_MFCView::AssertValid() const
{
	CView::AssertValid();
}

void CMenu_MFCView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMenu_MFCDoc* CMenu_MFCView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMenu_MFCDoc)));
	return (CMenu_MFCDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView drawing

void CMenu_MFCView::OnDraw(CDC* pDC)
{
	CMenu_MFCDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	RECT rt;
	GetClientRect(&rt);
	if( CurrentShape == IDM_RECTANGLE )
	{
		if( IsRounded )
			pDC->RoundRect( rt.left+10, rt.top+10, rt.right-10, rt.bottom-10, 25, 25 );
		else
			pDC->Rectangle( rt.left+10, rt.top+10, rt.right-10, rt.bottom-10 );
		}
	else
		pDC->Ellipse( rt.left+10, rt.top+10, rt.right-10, rt.bottom-10 );

}
/////////////////////////////////////////////////////////////////////////////
// CMenu_MFCView message handlers

void CMenu_MFCView::OnRectangle() 
{
	CurrentShape = IDM_RECTANGLE;
	InvalidateRect( NULL );
}

void CMenu_MFCView::OnCircle() 
{
	CurrentShape = IDM_CIRCLE;
	InvalidateRect( NULL );
}

void CMenu_MFCView::OnRounded() 
{
	IsRounded = ! IsRounded;
	InvalidateRect( NULL );
}

void CMenu_MFCView::OnUpdateRectangle(CCmdUI* pCmdUI) 
{
	if( CurrentShape == IDM_RECTANGLE )
		pCmdUI->SetCheck( TRUE );
	else
		pCmdUI->SetCheck( FALSE );
}

void CMenu_MFCView::OnUpdateCircle(CCmdUI* pCmdUI) 
{
	if( CurrentShape == IDM_CIRCLE )
		pCmdUI->SetCheck( TRUE );
	else
		pCmdUI->SetCheck( FALSE );
}

void CMenu_MFCView::OnUpdateRounded(CCmdUI* pCmdUI) 
{
	if( IsRounded )
		pCmdUI->SetCheck( TRUE );
	else
		pCmdUI->SetCheck( FALSE );
	if( CurrentShape == IDM_RECTANGLE )
		pCmdUI->Enable( TRUE );
	else
		pCmdUI->Enable( FALSE );

}

void CMenu_MFCView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu Tmp;
	Tmp.LoadMenu( IDR_POPUPMENU );
	CMenu* pPopup = Tmp.GetSubMenu(0);
	pPopup->TrackPopupMenu(TPM_RIGHTBUTTON, point.x, point.y, this );

}

void CMenu_MFCView::OnAdd() 
{
	MessageBox( "You selected Add" );	
}

void CMenu_MFCView::OnDelete() 
{
	MessageBox( "You selected Delete" );	
}

void CMenu_MFCView::OnEdit() 
{
	MessageBox( "You selected Edit" );	
}


