// CmnDlg_MFCView.cpp : implementation of the CCmnDlg_MFCView class
//

#include "stdafx.h"
#include "CmnDlg_MFC.h"
#include <shlobj.h>

#include "CmnDlg_MFCDoc.h"
#include "CmnDlg_MFCView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView

static UINT WM_FINDREPLACE = ::RegisterWindowMessage(FINDMSGSTRING);

IMPLEMENT_DYNCREATE(CCmnDlg_MFCView, CView)

BEGIN_MESSAGE_MAP(CCmnDlg_MFCView, CView)
	//{{AFX_MSG_MAP(CCmnDlg_MFCView)
	ON_COMMAND(IDM_BROWSEFOLDER, OnBrowsefolder)
	ON_COMMAND(IDM_CHOOSECOLOR, OnChoosecolor)
	ON_COMMAND(IDM_CHOOSEFONT, OnChoosefont)
	ON_COMMAND(IDM_FINDTEXT, OnFindtext)
	ON_COMMAND(IDM_GETOPENFILENAME, OnGetopenfilename)
	ON_COMMAND(IDM_GETSAVEFILE, OnGetsavefile)
	ON_COMMAND(IDM_PAGESETUP, OnPagesetup)
	ON_COMMAND(IDM_PRINTDLG, OnPrintdlg)
	ON_COMMAND(IDM_REPLACETEXT, OnReplacetext)
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE( WM_FINDREPLACE, OnFindReplace )
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView construction/destruction

CCmnDlg_MFCView::CCmnDlg_MFCView() : m_Print(FALSE)
{
	// TODO: add construction code here
	m_pFindData = 0;
}

CCmnDlg_MFCView::~CCmnDlg_MFCView()
{
}

BOOL CCmnDlg_MFCView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView drawing

void CCmnDlg_MFCView::OnDraw(CDC* pDC)
{
	CCmnDlg_MFCDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

	if( !m_Font.GetSafeHandle() ) // Font not created yet
	{
		m_Font.CreatePointFont( 120, "Times New Roman" ); // Set default font
		m_FontColor = 0; // Set black font color
	}

	pDC->SelectObject( &m_Font );
	pDC->SetTextColor( m_FontColor );

	pDC->TextOut( 0, 0, "Hello World" );
}

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView printing

BOOL CCmnDlg_MFCView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCmnDlg_MFCView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCmnDlg_MFCView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView diagnostics

#ifdef _DEBUG
void CCmnDlg_MFCView::AssertValid() const
{
	CView::AssertValid();
}

void CCmnDlg_MFCView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCmnDlg_MFCDoc* CCmnDlg_MFCView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCmnDlg_MFCDoc)));
	return (CCmnDlg_MFCDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCmnDlg_MFCView message handlers
BOOL CCmnDlg_MFCView::DemoBrowseForFolder( HWND hWnd, const char* Title, char* Dest )
{
	// Dest is assumed to be _MAX_PATH characters in length	
	// Remember to #include <shlobj.h>
	BROWSEINFO bi;
	ITEMIDLIST * pItemIDList;	
	IMalloc * pMalloc;
	
	if( CoGetMalloc( 1, &pMalloc ) != S_OK )
		return( FALSE );

	// Folder Only will contain the folder name, without full path
	char FolderOnly[_MAX_PATH];	
	// Initialize all members to zero
	memset( &bi, 0, sizeof(bi) );
	bi.hwndOwner=hWnd;   // Window handle from the view class
	bi.lpszTitle = Title; // Caption to appear above the tree control
	bi.pszDisplayName=FolderOnly; // Where to store folder name
	if( (pItemIDList=SHBrowseForFolder(  &bi )) != NULL )	
	{
		//ShBrowseForFolder doesn't get you the actual folder name, but
		// an ITEMIDLIST struct pointer.  The SHGetPathFromIDList function
		// converts this structure pointer into a valid pathname.
		SHGetPathFromIDList( pItemIDList, Dest );		
		pMalloc->Free( pItemIDList );
		return( TRUE );
	}	
	return( FALSE );
}

void CCmnDlg_MFCView::OnBrowsefolder() 
{
	char Path[_MAX_PATH];
	if( DemoBrowseForFolder( m_hWnd, "Pick a folder for demo:", Path ) )
		MessageBox( Path, "Folder you picked" );
}


BOOL CCmnDlg_MFCView::SelectColor(COLORREF *CurColor)
{
	CColorDialog Tmp( *CurColor, CC_ANYCOLOR | CC_RGBINIT, this );

	if( Tmp.DoModal() == IDOK )
	{
		CString Msg;
		Msg.Format( "You selected color %d", Tmp.GetColor() );
		*CurColor = Tmp.GetColor();
		return( TRUE );
	}
	return( FALSE );
}

void CCmnDlg_MFCView::OnChoosecolor() 
{
	static COLORREF CurColor; // start with zero = black
	SelectColor( &CurColor );
}



BOOL CCmnDlg_MFCView::SelectFont(CFont *CurFont, COLORREF* CurColor)
{
	LOGFONT LogFont;

	// Initialize LogFont with information from the font we were given.
	CurFont->GetLogFont( &LogFont );
	// Construct the CFontDialog, and initialize it with information from the LogFont structure
	CFontDialog Tmp( &LogFont );

	// Place the current color selection into the CFontDialog object.
	Tmp.m_cf.rgbColors = *CurColor;
	
	if( Tmp.DoModal() == IDOK )	// Invoke the dialog, and check if user hit 'Ok'
	{
		CurFont->DeleteObject(); // Delete old font
		CurFont->CreateFontIndirect( &LogFont ); // Create new font from user selection
		*CurColor = Tmp.m_cf.rgbColors; // Retrieve users color selection
		return( TRUE );
	}
	return( FALSE ); // Return FALSE if user hit Cancel

}

void CCmnDlg_MFCView::OnChoosefont() 
{
	if( SelectFont( &m_Font, &m_FontColor ) )
		InvalidateRect(NULL); // Force text to be redrawn, if font changed

}

void CCmnDlg_MFCView::OnFindtext() 
{
	if( m_pFindData ) // Already open?
		m_pFindData->EndDialog( IDOK ); // Does a 'delete' automatically
	m_pFindData = new CFindReplaceDialog();
	m_pFindData->Create( TRUE, "", NULL, FR_DOWN, this );
	
}

void CCmnDlg_MFCView::OnReplacetext() 
{
	if( m_pFindData ) // Already open?
		m_pFindData->EndDialog( IDOK ); // Does a 'delete' automatically
	m_pFindData = new CFindReplaceDialog();
	m_pFindData->Create( FALSE, "", NULL, FR_DOWN, this );
	
}

LONG CCmnDlg_MFCView::OnFindReplace(WPARAM wParam, LPARAM lParam)
{
		CString Str;
		FINDREPLACE* pFindReplace = (FINDREPLACE*)lParam;

		if( pFindReplace->Flags & FR_FINDNEXT )
		{
			Str.Format("I was asked to find the next '%s'", pFindReplace->lpstrFindWhat );
			if( pFindReplace->Flags & FR_DOWN )
				Str += " (down)";
			else
				Str += " (up)";
		}
		else if( pFindReplace->Flags & FR_REPLACE )
			Str.Format( "I was asked to replace the next '%s' with '%s'", pFindReplace->lpstrFindWhat,
				pFindReplace->lpstrReplaceWith );
		else if( pFindReplace->Flags & FR_REPLACEALL )
		{
			Str.Format( "I was asked to replace all '%s' with '%s'", pFindReplace->lpstrFindWhat,
				pFindReplace->lpstrReplaceWith );
			if( pFindReplace->Flags & FR_DOWN )
				Str += " (down)";
			else
				Str += " (up)";
		}
		else
			Str.Format( "I was asked to find '%s'", pFindReplace->lpstrFindWhat );
		MessageBox( Str );
	return(0);
}

void CCmnDlg_MFCView::OnGetopenfilename() 
{
	static char Filter[]="All Files (*.*)|*.*|Text Files (*.txt)|*.txt||";
 

	CFileDialog Tmp( TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Filter); // TRUE makes it an 'Open' dialog

	if( Tmp.DoModal()==IDOK )
		MessageBox( Tmp.GetPathName() ); // Display user's selection
	
}

void CCmnDlg_MFCView::OnGetsavefile() 
{
	static char Filter[]="All Files (*.*)|*.*|Text Files (*.txt)|*.txt||";
 
	CFileDialog Tmp( FALSE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, Filter); // TRUE makes it an 'Open' dialog

	if( Tmp.DoModal()==IDOK )
		MessageBox( Tmp.GetPathName() ); // Display user's selection
	
}

void CCmnDlg_MFCView::OnPagesetup() 
{

	m_PageSetup.DoModal();
	
}

void CCmnDlg_MFCView::OnPrintdlg() 
{
	if( m_Print.DoModal() == IDOK ) // If user clicked OK
	{
		CDC PrinterDC;
		PrinterDC.Attach( m_Print.GetPrinterDC() );
		// Use PrinterDC to do printing.
		// When done, clean up
		// We don't need to call Detach or DeleteDC for PrinterDC, because
		// its cdestructor does it for us.
	}

	// To get the default printer DC without displaying the dialog:
	//CDC PrinterDC;
	//PrinterDC.Attach( m_Print.CreatePrinterDC( ) );
	// Then, do the printing here.
}

void CCmnDlg_MFCView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	if( m_PageSetup.m_psd.rtMargin.bottom==0 )
	{
		m_PageSetup.m_psd.rtMargin.bottom = 1000;
		m_PageSetup.m_psd.rtMargin.top = 1000;
		m_PageSetup.m_psd.rtMargin.left = 1000;
		m_PageSetup.m_psd.rtMargin.right = 1000;
	}
	
}
