#include <windows.h>

LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );

char strClassName[]= "HelloWnd";	

int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nCmdShow )
{
	HWND hWnd;
	MSG Msg;
	WNDCLASS WndClass;

	WndClass.hInstance = hInst;
	WndClass.lpszClassName = strClassName;
	WndClass.lpfnWndProc = WndProc;
	WndClass.style = 0;	
	WndClass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
	WndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
	WndClass.lpszMenuName = NULL;
	WndClass.hbrBackground = (HBRUSH) GetStockObject( WHITE_BRUSH );
	WndClass.cbClsExtra = 0; 
	WndClass.cbWndExtra = 0; 

	if( !RegisterClass( &WndClass ) )
	{
		MessageBox( NULL, "Error registering class", NULL, MB_ICONEXCLAMATION|MB_OK );
		return( 0 );
	}

	hWnd = CreateWindow( strClassName, "Hello", WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, HWND_DESKTOP, NULL, hInst, NULL );
	if( !hWnd )
	{
		MessageBox(NULL, "Error creating window", NULL, MB_ICONEXCLAMATION|MB_OK);
		return( 0 );
	}
	
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	while( GetMessage( &Msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &Msg );
		DispatchMessage( &Msg );	
	}
	return( Msg.wParam );
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam )
{
	HDC DC;
	PAINTSTRUCT PaintStruct;
	switch( uMessage )
	{
		case WM_PAINT:	// PN: Draw Hello world in client area
			DC = BeginPaint( hWnd, &PaintStruct );
			TextOut( DC, 0, 0, "Hello World", 11 );
			EndPaint( hWnd, &PaintStruct );
			break;

		case WM_CLOSE:
			// PN: Confirm Exit
			if( MessageBox( hWnd, "Are you sure you want to exit?", "Confirmation", MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON1 ) == IDYES )
				PostQuitMessage(0);
			break;

		default:
	        return( DefWindowProc( hWnd, uMessage, wParam, lParam ) );
	}
	return( 0 );
}

