// SMTP.cpp: implementation of the CSMTP class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PNSMTP.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BOOL CPNSMTP::Connect(LPCSTR lpszHostAddress, UINT nHostPort)
{
	BOOL Ret = CPNCommandSocket::Connect( lpszHostAddress, nHostPort );
	if( Ret )
	{
		if( !SendCommand( 0, 0, 0, "220" ) )
			return( FALSE );
		else
			return( TRUE );
	}
	return( FALSE );
}

BOOL CPNSMTP::SendMail(LPCSTR From, LPCSTR To, LPCSTR Subject, LPCSTR Msg)
{

	CString Tmp;

	char *Domain = strchr( From, '@' );
	if( Domain )
		Domain++;
	else
		Domain="nowhere.com";

	if( !SendCommand( "HELO %s\n", Domain, &m_Error, "250" ) )
		return( FALSE );
	if( !SendCommand( "MAIL FROM: %s\n", From, &m_Error, "250" ) )
		return( FALSE );
	if( !SendCommand( "RCPT TO: %s\n", To, &m_Error, "250") )
		return( FALSE );
	if( !SendCommand( "DATA\n", "", &m_Error, "354" ) )
		return( FALSE );
	SendCommand( "To: %s\n", To, 0, 0 );
	SendCommand( "Subject: %s\n", Subject, 0, 0);
	if( !SendCommand( "%s\n.\n", Msg, &m_Error, "250" ) )
		return( FALSE );
	return(TRUE);	

}

CString& CPNSMTP::GetErrMsg()
{
	return( m_Error );
}
