// PNComboBox.cpp : implementation file
//

#include "stdafx.h"

#include "PNComboBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPNComboBox
bool CPNComboBox::m_RegistrySave=false;
CPNComboBox::CPNComboBox()
{
	m_DoLookup = m_DoPerLookup = true;
	m_MyRegistrySave = false;
}

CPNComboBox::~CPNComboBox()
{
}


BEGIN_MESSAGE_MAP(CPNComboBox, CComboBox)
	//{{AFX_MSG_MAP(CPNComboBox)
	ON_WM_DESTROY()
	ON_CONTROL_REFLECT(CBN_EDITUPDATE, OnEditupdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPNComboBox message handlers

void CPNComboBox::PreSubclassWindow() 
{
	if( ShouldSave()  ) // Should we load strings from registry?
	{
		CString Value;
		CString Family, Setting;
		int j, DialogID, ID;
		CWinApp* pApp = AfxGetApp();


		// determine ID for parent dialog and this combobox control
		DialogID = GetParent()->GetDlgCtrlID();
		ID = GetDlgCtrlID();
		// Set registry key for this specific dialog 
		Family.Format( "PNComboBox%d", DialogID );
		j=0;
		do {
			// Load each string from the dialogs settings (for this control)
			Setting.Format("ComboBoxStr%d-%d", ID, j++ );
			Value=pApp->GetProfileString( Family, Setting );
			if( Value!="" )
				AddString( Value );
		} while (Value!="");
	}
	CComboBox::PreSubclassWindow();
}

void CPNComboBox::OnDestroy() 
{
	if( ShouldSave() )
	{

		int i, ID;
		CString Text, Family, Setting;
		CWinApp* pApp = AfxGetApp();
	
		// Set Family with the unique ID for the parent dialog
		Family.Format("PNComboBox%d", GetParent()->GetDlgCtrlID() );
		int OldItems = pApp->GetProfileInt( Family, "Count", 0 );

		ID = GetDlgCtrlID();
		pApp->WriteProfileInt( Family, "Count", GetCount() );

		for( i=0; i < GetCount(); i++ )
		{
			GetLBText( i, Text );
			Setting.Format( "ComboBoxStr%d-%d", ID, i );
			if( !Text.IsEmpty() )
				pApp->WriteProfileString( Family, Setting, Text );
		}
		
		while( i < OldItems ) // There's a better way: keep the count of items in registry, and delete only whats needed
		{
			Setting.Format( "ComboBoxStr%d-%d", ID, i++ );
			pApp->WriteProfileString( Family, Setting, NULL );
		}
	}
	CComboBox::OnDestroy();
	
}

BOOL CPNComboBox::PreTranslateMessage(MSG* pMsg) 
{
	if( ::GetParent( pMsg->hwnd ) == m_hWnd && pMsg->message == WM_KEYDOWN )
	{
		if( pMsg->wParam==VK_RETURN)
		{
			TRACE("Post message\n");
			AfxGetMainWnd()->PostMessage( WM_COMMAND, MAKELPARAM(GetDlgCtrlID(),CBN_SELCHANGE), (LPARAM)m_hWnd );
		}
		else
		{
			if( pMsg->wParam == VK_BACK || pMsg->wParam == VK_DELETE )
				m_DoPerLookup = false;
		}
	}
	return CComboBox::PreTranslateMessage(pMsg);
}

void CPNComboBox::SetAllRegistrySave(bool Mode)
{
	m_RegistrySave = Mode;
}

int CPNComboBox::AddString( LPCSTR pNewString )
{
	// Don't add duplicates
	CString Tmp;
	if( pNewString == 0 )
		GetWindowText( Tmp );
	else
		Tmp = pNewString;
	int Index = FindStringExact( 0, Tmp );
	if( Index < 0 )
		Index = CComboBox::AddString( Tmp );
	return( Index );
}

void CPNComboBox::OnEditupdate() 
{
	if( !m_DoLookup || !m_DoPerLookup )
	{
		m_DoPerLookup = true;
		return;
	}

	CEdit* Tmp = (CEdit*)GetDlgItem( 1001 );
	int StartSel, EndSel;
	Tmp->GetSel( StartSel, EndSel );
	CString strTmp;
	Tmp->GetWindowText(strTmp );

	if( StartSel && StartSel == EndSel && StartSel==strTmp.GetLength() )
	{
		int Index;
		if( (Index=SelectString( -1, strTmp )) >= 0 )
		{
			GetLBText( Index, strTmp );
			SetWindowText( strTmp );
			Tmp->SetSel( StartSel, strTmp.GetLength() );
			return;
		}
		SetWindowText( strTmp );
		Tmp->SetSel( StartSel, StartSel );
	}
}

bool CPNComboBox::ShouldSave()
{
	// Determine if all are set to save, 
	if( m_RegistrySave == true )
		return( true );
	return( m_MyRegistrySave );
}
